#ifndef K3DSDK_IPROPERTY_COLLECTION_H
#define K3DSDK_IPROPERTY_COLLECTION_H

// K-3D
// Copyright (c) 1995-2005, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Declares iproperty_collection, an abstract interface for wrapping a collection of iproperty objects
		\author Tim Shead (tshead@k-3d.com)
*/

#include "iunknown.h"
#include "signal_system.h"

#include <vector>

namespace k3d
{

// Forward declarations
class iproperty;

/// Abstract interface for objects that can accept commands from external entities
class iproperty_collection :
	public virtual iunknown
{
public:
	/// Registers a property with the collection - note: the collection will assume responsibility for the lifetime of user properties only
	virtual void register_property(iproperty& Property) = 0;
	/// Removes a property from the collection
	virtual void unregister_property(iproperty& Property) = 0;
	/// Defines a collection of properties
	typedef std::vector<iproperty*> properties_t;
	/// Returns the set of all properties provided by this object
	virtual const properties_t& properties() = 0;
	/// Defines a signal emitted whenever the collection changes - note: this signal is emitted when the collection changes (properties are added or deleted), not when individual property values are changed
	typedef sigc::signal1<void, iunknown*> properties_changed_signal_t;
	virtual properties_changed_signal_t& properties_changed_signal() = 0;

protected:
	iproperty_collection() {}
	iproperty_collection(const iproperty_collection&) {}
	iproperty_collection& operator=(const iproperty_collection&) { return *this; }
	virtual ~iproperty_collection() {}
};

} // namespace k3d

#endif // K3DSDK_IPROPERTY_COLLECTION_H


