#ifndef BITMAP_BASIC_BITMAP_MODIFIER_H
#define BITMAP_BASIC_BITMAP_MODIFIER_H

// K-3D
// Copyright (c) 1995-2005, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\author Anders Dahnielson (anders@dahnielson.com)
*/

#include <k3dsdk/bitmap_modifier.h>
#include <k3dsdk/node.h>
#include <k3dsdk/persistent.h>

namespace libk3dbitmap
{

/** \todo Bring this up-to-date with the bitmap_source, mesh_source, and mesh_modifier classes */
class basic_bitmap_modifier :
	public k3d::bitmap_modifier<k3d::persistent<k3d::node> >
{
	typedef k3d::bitmap_modifier<k3d::persistent<k3d::node> > base;

public:
	basic_bitmap_modifier(k3d::idocument& Document) :
		base(Document)
	{
		m_input.changed_signal().connect(m_output.make_reset_slot());
	}

	void on_reset_bitmap(k3d::iunknown* const Hint)
	{
		m_output.reset(0, Hint);
	}

	void on_create_bitmap(k3d::bitmap& Bitmap)
	{
		// If we don't have any input bitmap, we're done ...
		const k3d::bitmap* const input = m_input.value();
		if(!input)
			return;

		// Update values
		on_value_change(0);

		// Otherwise, we make a copy of the input bitmap and modify the copy ...
		Bitmap = *input;
		for(k3d::bitmap::iterator O = Bitmap.begin(); O != Bitmap.end(); ++O)
		{
			k3d::pixel I = *O;
			on_filter(I, *O);
		}
	}

	virtual void on_value_change(k3d::iunknown*) = 0;
	virtual void on_filter(const k3d::pixel& I, k3d::pixel& O) = 0;
};

} // namespace libk3dbitmap

#endif // !BITMAP_BASIC_BITMAP_MODIFIER_H

