SET(K3D_BOOST_FOUND 0)
SET(Boost_ADDITIONAL_VERSIONS 1.37 1.38)
SET(K3D_BOOST_COMPILER "" CACHE STRING
	"Compiler identification embedded in the boost library names")
MARK_AS_ADVANCED(K3D_BOOST_COMPILER)
IF(NOT ${K3D_BOOST_COMPILER} STREQUAL "")
	SET(Boost_COMPILER ${K3D_BOOST_COMPILER})
ENDIF(NOT ${K3D_BOOST_COMPILER} STREQUAL "")
IF(WIN32)
	SET(BOOST_ROOT "C:/Program Files/Boost")
ENDIF(WIN32)

#components that are always needed
SET(K3D_BOOST_COMPONENTS date_time program_options regex unit_test_framework)

# python lib
IF(${K3D_BUILD_PYTHON_MODULE} STREQUAL "ON")
	SET(K3D_BOOST_COMPONENTS ${K3D_BOOST_COMPONENTS} python)
ENDIF()

# libs needed by collada
IF(${K3D_BUILD_COLLADA_IO_MODULE} STREQUAL "ON")
	SET(K3D_BOOST_COMPONENTS ${K3D_BOOST_COMPONENTS} filesystem system)
ENDIF()

#libs needed by CGAL
IF(${K3D_BUILD_CGAL_MODULE} STREQUAL "ON")
	SET(K3D_BOOST_COMPONENTS ${K3D_BOOST_COMPONENTS} thread)
ENDIF()

FIND_PACKAGE(Boost 1.34 COMPONENTS ${K3D_BOOST_COMPONENTS})

SET(K3D_BOOST_FOUND ${Boost_FOUND})

SET(K3D_BOOST_INCLUDE_DIRS
	${Boost_INCLUDE_DIRS}
	)
SET(K3D_BOOST_DATE_TIME_LIBS
	${Boost_DATE_TIME_LIBRARY}
	)
SET(K3D_BOOST_PROGRAM_OPTIONS_LIBS
	${Boost_PROGRAM_OPTIONS_LIBRARY}
	)
SET(K3D_BOOST_PYTHON_LIBS
	${Boost_PYTHON_LIBRARY}
	)
SET(K3D_BOOST_REGEX_LIBS
	${Boost_REGEX_LIBRARY}
	)
SET(K3D_BOOST_FILESYSTEM_LIBS
	${Boost_FILESYSTEM_LIBRARY}
	)
SET(K3D_BOOST_SYSTEM_LIBS
	${Boost_SYSTEM_LIBRARY}
	)
SET(K3D_BOOST_THREAD_LIBS
	${Boost_THREAD_LIBRARY}
	)
SET(K3D_BOOST_UNIT_TEST_FRAMEWORK_LIBS
	${Boost_UNIT_TEST_FRAMEWORK_LIBRARY}
	)
