//
// C++ Implementation: k9mp4enc
//
// Description:
//
//
// Author: Jean-Michel PETIT <k9copy@free.fr>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "k9mp4enc.h"
#include "k9mp4dlg.h"
#include "k9config.h"
#include <qapplication.h>
#include <klocale.h>
#include <qstringlist.h>
#include <qdir.h>
#include <kfiledialog.h>
#include <kmessagebox.h>
#include <qstringlist.h>
#include <KTemporaryFile>
#include <kstandarddirs.h>
#include "k9tools.h"
#include "k9audiocodecs.h"
#include "k9videocodecs.h"
#include "k9convertaudio.h"
#include <QByteArray>
#include "k9dialogs.h"
#include <KShell>
#include <QMutex>
#include <math.h>
#include "k9ifo2.h"
#include "k9cell.h"
#define SERVICE_NAME "k9copy.free.fr.player"
#define BASE_CONV_AUDIO 0
#define BASE_CONV_VIDEO 10
#define BASE_CONV_SUBTITLE 20



k9MP4Enc::k9MP4Enc(QObject *parent)
        : k9DVDBackupInterface(parent) {
    m_fourcc=m_height=m_width=m_audioBitrate=m_videoBitrate=m_filename="";
    m_codec=0; //lavc_mp4;
    m_audioCodec=0;
    m_cpt=-1;
    m_parts=1;
    m_mpeg2=false;
    m_extractAudio=false;
    m_extractMkv=false;
    m_extractSubtitle=false;

    QStringList laudio;
    QStringList llabels;
    QStringList lvideo;

    k9Config config;
    m_splitChapters=config.getMpegChapters();

    timer = new QTimer( this );
    connect( timer, SIGNAL(timeout()), this, SLOT(timerDone()) );
    m_progress=new k9MP4Dlg(k9Dialogs::getMainWidget());
    m_progress->setModal(true);

}

QString k9MP4Enc::round16(QString _wh) {
    if (_wh !="") {
        int value=_wh.toInt()/16;
        return QString::number(value*16);

    } else
        return _wh;


}

QString k9MP4Enc::getChapterList(k9DVDTitle *_title) {
    QString res="";
    QList <k9DVDChapter*> chapters=_title->getChapters();
    foreach (k9DVDChapter *chapter ,chapters) {
        if (chapter->getSelected()) {
            res+=res=="" ? QString::number( chapter->getnum()) : ","+QString::number( chapter->getnum());
        }
    }
    QList <k9DVDTitle*> titles=_title->getTitles();

    foreach (k9DVDTitle *title,titles) {
        chapters=title->getChapters();
        foreach (k9DVDChapter *chapter,chapters) {
            if (chapter->getSelected()) {
                res+=res=="" ? QString::number( chapter->getnum()) : ","+QString::number( chapter->getnum());
            }
        }
    }
    return res;

}


int k9MP4Enc::getselectedSubp(k9DVDTitle *_title) {
    for (int i=0;i< _title->getsubPictureCount();i++) {
        if (_title->getsubtitle( i)->getselected()) {
            return _title->getsubtitle(i)->getID().first()-1;
        }
    }
    //nos subtitle selected
    return -1;
}

bool k9MP4Enc::check() {
    if (m_mpeg2)
        return true;

    QString sCodecA,sCodecV;

    k9AudioCodecs *audioCodecs=new k9AudioCodecs(0);
    sCodecA=audioCodecs->getEncoder(m_audioCodec);

    if (m_extractAudio && sCodecA !="ffmpeg") {
        k9Dialogs::error(i18n("Audio extraction can only be done with ffmpeg"),i18n("Encoding error"));
        return false;
    }

    k9VideoCodecs *videoCodecs=new k9VideoCodecs(0);
    sCodecV=videoCodecs->getEncoder (m_codec);

    if (m_extractMkv && sCodecV!="ffmpeg") {
        k9Dialogs::error(i18n("Matroska encoding can only be done with ffmpeg"),i18n("Encoding error"));
        return false;
    }

    if (!m_extractAudio) {
        if ( ! k9Tools::checkProgram(sCodecV) ) {
            k9Dialogs::error (i18n("Unable to run %1",sCodecV) , i18n("Encoding error"));
            m_error = TRUE;
            return false;
        }
    }



    if ((sCodecA!=sCodecV) || m_extractAudio) {
        if ( ! k9Tools::checkProgram(sCodecA) ) {
            k9Dialogs::error (i18n("Unable to run %1",sCodecA) , i18n("Encoding error"));
            m_error = TRUE;
            return false;
        }
    }


    return true;
}

void k9MP4Enc::execute(k9DVDTitle *_title) {
    m_currentChapter=0;
    m_error=false;
    m_outputFile=NULL;
    m_converters[BASE_CONV_VIDEO]=NULL;
    if (m_mpeg2 || m_extractAudio) {
        m_parts=1;
        m_2pass=false;
    }

    m_error = !check();
    if (m_error)
        return;

    time = new QTime(0,0);
    m_percent=m_totalBytes=m_offset=0;
    m_remain="--:--:--";

    m_totalSize=_title->getChaptersSize(true);

    QString injectName;
    KTemporaryFile injectFile;
    injectFile.setPrefix(KStandardDirs::locateLocal("tmp", "k9copy/k9v"));
    injectFile.open();
    injectName=injectFile.fileName();

    injectFile.setAutoRemove(true);
    injectFile.close();


    int maxPass=0;
    int pass=0;

    //build the cell list for mpeg2 extraction
    QMultiMap <int,int> chapterCells;
    QStringList chapters;
    /*  if ((m_extractSubtitle) && m_splitChapters) {
          m_parts=0;
          chapters=getChapterList(_title).split(",");
          foreach (QString chapter,chapters) {
              int iCell=0;
    //            k9DVDChapter *chap=_title->getChapter(chapter.toInt()-1);
    //	 foreach(k9ChapterCell *cell ,chap->cells) {
              iCell++;
              chapterCells.insert(chapter.toInt(),iCell);
              m_parts++;
    //	 }
          }
          ichapterCells = chapterCells.begin();
      }
    */

    for ( m_part =1 ; (m_part <=m_parts) && !m_error ;m_part++) {
        if (m_2pass) {
            maxPass=2;
            pass=1;
        }
        KTemporaryFile passLogFile;
        QString passLogFileName;
        passLogFile.setPrefix(KStandardDirs::locateLocal("tmp", "k9copy/k9v"));
        passLogFile.setAutoRemove(true);
        passLogFile.open();
        passLogFileName=passLogFile.fileName();
        passLogFile.close();
        m_passLogFile=passLogFileName;

        do {
            m_player=new k9play(this);

            uint32_t nbSectors= m_totalSize / m_parts   ;

            uint32_t startSector= nbSectors*(m_part-1);
            uint32_t endSector= startSector+nbSectors;

            //calculer le bitrate en faisant la somme des cells compris entre startSector et endSector
            //FIXME Mettre en place la sélection par chapitres
            m_stderr="";
            m_title=_title;
            if (m_width=="") {
                m_width=_title->getwidth();
            }
            if (m_width.toInt() % 2 !=0)
                m_width=QString::number(m_width.toInt()+1);
	    double h=(double)_title->getheight().toInt();
	    double w=(double)_title->getwidth().toInt();
	    
	    double ratio=( m_width.toDouble()/w);

  	    k9VideoCodecs videoCodecs;

            if (m_height=="" || m_height=="0") {
                double height=h*ratio;
                m_height=QString::number((int)round(height+0.1));
  	        //with mencoder, video is resized after the cropping has been applied
		//=> height=height - (cropheight*aspectratio)
  	        if (videoCodecs.getEncoder(m_codec)=="mencoder") 
		   m_height= QString::number((int)(m_height.toInt() -(h-m_crop.height())*ratio));
            }

	 
	    if (videoCodecs.getEncoder(m_codec)=="ffmpeg") { 
		//with ffmpeg, crop is applied on the resized video => crop size must be calculated according to ratio
		QRect newrect(m_crop.left()*ratio,m_crop.top()*ratio,m_crop.width()*ratio,m_crop.height()*ratio);
		m_crop=newrect;
 	    }

            if (m_height.toInt()%2 !=0)
                m_height=QString::number(m_height.toInt()+1);

            if (m_audioBitrate=="")
                m_audioBitrate="128";
            if (m_size=="")
                m_size="700";
            if (m_filename=="")
                m_filename=k9Dialogs::getSaveFileName (QDir::homePath(),"*.avi", 0,i18n("Save file to disk"));
            if (m_filename =="")
                return;

            QDir d=QDir::root();
            if (d.exists(m_filename))
                d.remove(m_filename);

            m_progress->setbitrate(QString::number(getBitRate(_title)));
            if (!m_mpeg2 && !m_extractAudio && !m_extractMkv) {
                m_progress->setsize(m_size +i18n("MB") +" X " +QString::number(m_parts));
                m_player->setendSector(QString::number(endSector));
            } else
                m_progress->setsize(m_size +i18n("MB") +" X ");


            QStringList cmd;

            m_player->setinject(injectName);
            m_player->setDevice(m_device);
            m_player->setTitle(_title->getnumTitle());

            m_player->setchapterList(getChapterList( _title));
            if (m_part==1 || m_mpeg2 ||m_extractAudio ) {
                m_player->setinitStatus(true);
                m_player->setcontinue(false);
            } else {
                m_player->setcontinue(true);
                m_player->setinitStatus(false);
            }
            if (pass==1)
                m_player->setfirstPass(true);
            else
                m_player->setfirstPass(false);

            if (pass !=1) {
                QStringList streams;
                for (int i=0;i<_title->getaudioStreamCount();i++) {
                    if (_title->getaudioStream(i)->getselected()) {
                        streams <<QString::number(_title->getaudioStream(i)->getID());
                    }
                }

                if (streams.count() >0)
                    m_player->setaudioFilter(streams.join(","));


                if (getselectedSubp( _title) !=-1) {
                    streams.clear();
                    for (int i=0; i<_title->getsubPictureCount();i++) {
                        if (_title->getsubtitle(i)->getselected()) {
                            streams << QString::number(_title->getsubtitle(i)->getID().first());
                        }

                    }
                    m_player->setsubpictureFilter(streams.join(","));
                }
            }
            m_player->setuseCache(m_usecache);

            if (m_mpeg2) {
                m_offset+=m_totalBytes;
                m_progress->setbitrate("--");
                double size;

                if (_title->getforceFactor()) {
                    size = _title->getChaptersSize_mb(true)/_title->getfactor();
                    m_player->setvampsFactor(QString::number(_title->getfactor()));
                    m_player->setforcedFactor(true);
                } else
                    size = _title->getChaptersSize_mb(true);
                m_progress->setsize(QString::number(size) +i18n("MB"));

                /*          QString path=m_filename;

                          if (m_parts>1) {
                              QString ext=m_filename.section(".",-1);
                              if (ext!="")
                                  ext="."+ext;
                              path=m_filename.left(m_filename.length()-ext.length());
                              //path=QString("%1-chapter%2-cell%3%4").arg(path).arg(ichapterCells.key()).arg(ichapterCells.value()).arg(ext);
                              path=QString("%1-chapter%2%3").arg(path).arg(ichapterCells.key()).arg(ext);
                          }
                */
                if (!m_splitChapters) {
                    m_outputFile=new QFile(m_filename);
                    //removes an existing file;
                    m_outputFile->remove();
                    m_outputFile->open(QIODevice::WriteOnly);
                }

            } else if (m_extractAudio) {
                //       m_offset+=m_totalBytes;
                //      buildAudioCmd(_title);
                if (!m_splitChapters)
                    buildAudioCmd(_title);
            } else {
                //cmd << "-of" << "avi";
                if (m_extractSubtitle && pass!=1)
                    buildSubtitleCmd(_title);
                buildVideoCmd(pass,m_part,_title,passLogFileName,cmd);
            }
            if ((m_parts >1 ) && (m_mpeg2|| m_extractAudio))
                ++ichapterCells;


            time->start();

            connect(m_progress,SIGNAL(sigCancel()),this,SLOT(slotCancel()));
            m_canceled=false;
            m_progress->show();

            timer->start(500);

            //connect(m_player,SIGNAL(sigPosition(uint, uint)),this,SLOT(getPosition(uint, uint)));

            QEventLoop eventLoop;

            //enters an new event loop which is stopped at end of the playing thread
            m_eventLoop= &eventLoop;
            m_player->setEventLoop(&eventLoop);
            m_player->execute();
            //eventLoop.exec();
            Flush();

            foreach (k9ConvertAudio *c,m_converters) {
                if (c) {
                    c->end();
                }
            }
            foreach(k9Subtitle2Pgm *s,m_subtitles) {
                if (s) {
                    s->end();
                }
            }

            qDeleteAll(m_subtitles);
            if (m_canceled) {
                //KMessageBox::information (NULL,i18n("MPEG-4 Encoding cancelled"), i18n("MPEG-4 Encoding"));
                m_error=true;
            }
            /*else if (!m_process->normalExit()) {
                    k9Dialogs::error ("<b>"+i18n("Error while running mencoder :") +"</b><br>"+m_stderr, i18n("Encoding error"));
                    m_error=true;
                }
            */
            if (maxPass >0)
                pass++;
            delete m_player;
            m_player = NULL;
        } while (pass<=maxPass && !m_error && m_2pass);

    }
    if (m_mpeg2 && m_outputFile) {
        m_outputFile->close();
        delete m_outputFile;
    }
    foreach (k9ConvertAudio *c,m_convertersToDelete) {
        c->end();
        delete c;
    }

    if (!m_msgError.isEmpty())
        k9Dialogs::error (m_msgError, i18n("Encoding error"),m_ErrorDetail);

}


void k9MP4Enc::buildSubtitleCmd(k9DVDTitle *title) {
    for (int i=0; i< title->getsubPictureCount();i++) {
        if (title->getsubtitle(i)->getselected()) {
            QStringList cmd;
            QString path=QDir::cleanPath( QString("%1/title%2-part%3-subtitle%4%5").arg(m_filename).arg(m_title->getnumTitle()).arg(m_part).arg(i+1).arg(""));
            QString path2=QDir::cleanPath( QString("%1/title%2-part%3-subtitle%4%5").arg(m_filename).arg(m_title->getnumTitle()).arg(m_part).arg(i+1).arg("mpg"));

            QFile::remove(path+".sub");
            QFile::remove(path+".idx");
            k9Subtitle2Pgm *subtitle2pgm=new k9Subtitle2Pgm(this);
            m_subtitles[title->getsubtitle(i)->getID().first()]=subtitle2pgm;
            subtitle2pgm->setBaseName(path);
            for (int ipalette=0;ipalette<16;ipalette++) {
                QString s;
                title->getpalette(ipalette,s);
                subtitle2pgm->setPalette(ipalette,s.toUInt());
            }
            subtitle2pgm->setLangCod(title->getsubtitle(i)->getlangCod());
            subtitle2pgm->setTrackCod(0x20+title->getsubtitle(i)->getID().first()-1);

            k9ResultingFile *rf=new k9ResultingFile(this);
            rf->title=m_title->getnumTitle();
            rf->filename=path+".idx";
            rf->subtitle=true;
            m_resultingFiles.insert(rf->title,rf);

        }

    }

}

void k9MP4Enc::buildAudioCmd(k9DVDTitle *title) {
    k9AudioCodecs *audioCodecs=new k9AudioCodecs(0);

    for (int i=0;i<title->getaudioStreamCount();i++) {
        if (title->getaudioStream(i)->getselected()) {

            k9DVDAudioStream *stream = title->getaudioStream(i);
            QStringList cmd;
            QString sCodec="";

            sCodec=audioCodecs->getCodecName(m_audioCodec);

            QString sAOption=replaceParams(audioCodecs->getOptions(m_audioCodec)).trimmed();

            m_progress->setTitleLabel(i18n("Encoding %1",sCodec));
            QString path,ext=audioCodecs->getExtension(m_audioCodec) ;
            if (!ext.startsWith("."))
                ext="."+ext;

            QDir().mkpath(m_filename);
            path=QDir::cleanPath( QString("%1/title%2-part%3-audio%4-%6-%5").arg(m_filename).arg(m_title->getnumTitle()).arg(m_currentChapter).arg(i+1).arg(ext).arg(stream->getlanguage()) );
            QFile::remove(path);


            cmd  << audioCodecs->getEncoder(m_audioCodec)<< "-i" << "/dev/stdin" <<sAOption.split(" ") <<  KShell::quoteArg(path) ;
            k9ConvertAudio *converter=new k9ConvertAudio("",cmd);
            //k9ConvertAudio *converter=new k9ConvertAudio("/home/jmp/test.mp3",QStringList());
            m_converters[BASE_CONV_AUDIO+i+1]=converter;
            m_convertersToDelete << converter;
            
        }
    }

    delete audioCodecs;

}

void k9MP4Enc::buildVideoCmd(int pass,int part,k9DVDTitle *title,const QString &passLogFileName,QStringList &cmd) {
    k9VideoCodecs videoCodecs;
    if (videoCodecs.getEncoder(m_codec)=="ffmpeg")
        buildFFMpegCmd(pass,title,cmd);
    else
        buildMEncoderCmd(pass,part,title,passLogFileName,cmd);

}


void k9MP4Enc::buildFFMpegCmd(int pass,k9DVDTitle *title,QStringList &cmd) {

    QString sPass="";
    QString sCodec="";

    k9VideoCodecs *videoCodecs=new k9VideoCodecs(0);
    k9AudioCodecs *audioCodecs=new k9AudioCodecs(0);

    QString sVOption;
    m_pass=pass;
    switch (pass) {
    case 1:
        sVOption=replaceParams(videoCodecs->getOptions1(m_codec));
        break;
    case 2:
        sVOption=replaceParams(videoCodecs->getOptions2(m_codec));
        break;
    default:
        sVOption=replaceParams(videoCodecs->getOptions0(m_codec));
        break;
    }


    sCodec=videoCodecs->getCodecName(m_codec);
    sVOption=sVOption.trimmed();
    cmd << videoCodecs->getEncoder(m_codec) << "-i" << "/dev/stdin";

    cmd << sVOption.split(" ");

    if (pass >0)
        m_progress->setTitleLabel(i18n("Encoding %1",sCodec)+" - "+i18n("pass %1",pass));
    else
        m_progress->setTitleLabel(i18n("Encoding %1",sCodec));

    if (m_fourcc !="")
        cmd << "-vtag" << m_fourcc;
    else if (videoCodecs->getFourcc(m_codec)!="")
        cmd << "-vtag" << videoCodecs->getFourcc(m_codec);

    QString sAOption="";
    sAOption=replaceParams(audioCodecs->getOptions(m_audioCodec)).trimmed();

    QStringList slNewAudio;
    delete audioCodecs;
    delete videoCodecs;
    bool audio=false;
    //looking for first audio selected
    int nbAudio=0;
    if (m_pass != 1 ) {
        for (int i=0;i<title->getaudioStreamCount();i++) {
            if (title->getaudioStream(i)->getselected()) {
                if (nbAudio>0)
                    slNewAudio << "-newaudio";
                else
                    cmd << sAOption.split(" ");
                audio=true;
                nbAudio++;
            }
        }
    }

    QString path=m_filename;

    if (m_pass==1) {
        path="/dev/null";
    } else if (m_extractMkv) {
        QString ext(".avi");
        QDir().mkpath(m_filename);
        path=QDir::cleanPath( QString("%1/title%2-part%3-video%4").arg(m_filename).arg(m_title->getnumTitle()).arg(m_part).arg(ext));
        QFile::remove(path);

        k9ResultingFile *rf=new k9ResultingFile(this);
        rf->title=m_title->getnumTitle();
        rf->filename=path;
        rf->video=true;
        m_resultingFiles.insert(rf->title,rf);
    }else {
	if (m_parts>1) {
		QString ext=m_filename.section(".",-1);
		if (ext!="")
		ext="."+ext;
		path=m_filename.left(m_filename.length()-ext.length());
		path=path+QString::number(m_part)+ext;
	}
    }

    if (path.toUpper().endsWith("MPEG") || path.toUpper().endsWith("MPG"))
        cmd << "-f" << "mpeg";
    else if (path.toUpper().endsWith("AVI") || m_pass==1)
        cmd << "-f" << "avi";
    else {
        //      cmd << "-of" << "lavf";
        //      cmd << "-lavfopts" << "i_certify_that_my_video_stream_does_not_use_b_frames";
    }
    cmd << "-y" << KShell::quoteArg(path);

    cmd << slNewAudio;
//    if (m_extractMkv) {
    k9ConvertAudio *converter=new k9ConvertAudio("",cmd);
    //converter->setDebug(true);
    m_converters[BASE_CONV_VIDEO]=converter;
    m_convertersToDelete << converter;
    if (m_extractMkv && m_pass!=1)
        for (int i=0;i<title->getaudioStreamCount();i++)
            if (title->getaudioStream(i)->getselected())
                m_converters[BASE_CONV_AUDIO+i+1]=converter;
//   }
}



void k9MP4Enc::buildMEncoderCmd(int pass,int part,k9DVDTitle *title,const QString &passLogFileName,QStringList &cmd) {

    bool audio=false;
    QString sPass="";
    QString sCodec="";

    k9AudioCodecs *audioCodecs=new k9AudioCodecs(0);
    k9VideoCodecs *videoCodecs=new k9VideoCodecs(0);

    QString sVOption;
    m_pass=pass;
    switch (pass) {
    case 1:
        sVOption=replaceParams(videoCodecs->getOptions1(m_codec));
        break;
    case 2:
        sVOption=replaceParams(videoCodecs->getOptions2(m_codec));
        break;
    default:
        sVOption=replaceParams(videoCodecs->getOptions0(m_codec));
        break;
    }
    sCodec=videoCodecs->getCodecName(m_codec);
    sVOption=sVOption.trimmed();
    int pos;
    cmd << "mencoder" << "/dev/stdin";
    if (pass >0)
        cmd << "-passlogfile" << passLogFileName;

    cmd << sVOption.split(" ");

    QString sAOption="";
    sAOption=replaceParams(audioCodecs->getOptions(m_audioCodec)).trimmed();


    if (pass >0)
        m_progress->setTitleLabel(i18n("Encoding %1",sCodec)+" - "+i18n("pass %1",pass));
    else
        m_progress->setTitleLabel(i18n("Encoding %1",sCodec));

    if (m_fourcc !="")
        cmd << "-ffourcc" << m_fourcc;
    else if (videoCodecs->getFourcc(m_codec)!="")
        cmd << "-ffourcc" << videoCodecs->getFourcc(m_codec);

    delete audioCodecs;
    delete videoCodecs;

    //looking for first audio selected
    for (int i=0;i<title->getaudioStreamCount();i++) {
        if (title->getaudioStream(i)->getselected()) {
            //cmd << "-oac" << sAOption;
            pos=sAOption.indexOf("-af");
            if (pos==-1)
                cmd << "-af" <<QString("volume=%1").arg(m_audioGain);
            else
                sAOption=sAOption.insert(pos+4,QString("volume=%1,").arg(m_audioGain));
            cmd << sAOption.split(" ");

            audio=true;
            break;
        }
    }

    if (getselectedSubp( title) !=-1) {
        cmd << "-sid" << QString::number(getselectedSubp( title));
        cmd << "-ffactor" << "1" << "-spualign" << "2" << "-sub-bg-alpha" << "1";
    }

    if (!audio)
        cmd << "-nosound";

    QString path=m_filename;

    if (m_parts>1) {
        QString ext=m_filename.section(".",-1);
        if (ext!="")
            ext="."+ext;
        path=m_filename.left(m_filename.length()-ext.length());
        path=path+QString::number(part)+ext;
    }
    if (pass==1)
        cmd << "-o" << "/dev/null";
    else
        cmd <<"-o" << KShell::quoteArg(path);
    if (path.toUpper().endsWith("MPEG") || path.toUpper().endsWith("MPG"))
        cmd << "-of" << "mpeg";
    else if (path.toUpper().endsWith("AVI"))
        cmd << "-of" << "avi";
    else {
        //      cmd << "-of" << "lavf";
        //      cmd << "-lavfopts" << "i_certify_that_my_video_stream_does_not_use_b_frames";
    }
    k9ConvertAudio *converter=new k9ConvertAudio("",cmd);
    converter->setDebug(false);
    m_converters[BASE_CONV_VIDEO]=converter;
    m_convertersToDelete << converter;
}

void k9MP4Enc::slotCancel() {
    m_canceled=true;
    timer->stop();
    m_player->abort();
    foreach (k9ConvertAudio *c,m_converters) {
        if (c)  {
            c->end(false);
        }
    }

}


QString k9MP4Enc::replaceParams(QString _value) {
    QString str=_value;
    str.replace("$PASSLOGFILE",m_passLogFile);
    str.replace("$PASS",QString::number(m_pass));
    str.replace("$WIDTH",m_width);
    str.replace("$HEIGHT",m_height);
    str.replace("$VIDBR",QString::number(getBitRate(m_title)));
    str.replace("$AUDBR",m_audioBitrate);
    int c=m_crop.top();
    if (c%2 !=0) c++;
    str.replace("$CROPTOP",QString::number(c));
    c=m_crop.left();
    if (c%2 !=0) c++;
    str.replace("$CROPLEFT",QString::number(c));
    c=m_height.toInt()- m_crop.bottom();
    if (c%2 !=0) c++;
    str.replace("$CROPBOTTOM",QString::number(c));
    c=m_width.toInt()-m_crop.right();
    if (c%2 !=0) c++;
    str.replace("$CROPRIGHT",QString::number(c));
    str.replace("$CROPWIDTH",QString::number(m_crop.width()));
    str.replace("$CROPHEIGHT",QString::number(m_crop.height()));
    str.replace("$ASPECT",QString::number((double)m_crop.width()/(double)m_crop.height()));
    return str;
}


int k9MP4Enc::getBitRate(k9DVDTitle *_title) {
    // bitrate video = (MB *8388.608) /SEC    - bitrate audio

    if (m_videoBitrate!="") {
        return  m_videoBitrate.toInt();
    } else {
        int size=m_size.toInt();
        float titleSize=_title->getChaptersSize_mb( true);
        if ( titleSize< (float)size)
            size=(int)(titleSize/m_parts) ;
        m_progress->setsize(QString::number(size) +i18n("MB") +" x " +QString::number(m_parts));
        QTime t1(0,0);
        int sec=t1.secsTo(_title->getSelectedLength());
        if (sec==0) return 0;
        int nbAudioStreams=0;
        for (int i=0;i<_title->getaudioStreamCount();i++)
            if (_title->getaudioStream(i)->getselected())
                nbAudioStreams++;

        nbAudioStreams=1;

        int bitrate=((8*size*m_parts*1024)-(m_audioBitrate.toInt()*nbAudioStreams*sec))/sec;


//	qDebug() << "bitrate:" << bitrate << " sec:" <<sec;
        return bitrate;
    }
}






void k9MP4Enc::timerDone() {
    if (m_player) {
        uint32_t totalBytes,totalSize;
        m_player->getPosition(&totalBytes,&totalSize);
        if (m_converters[BASE_CONV_VIDEO])
            m_progress->setfps(m_converters[BASE_CONV_VIDEO]->getFps());
        if (totalSize !=0)
            m_percent=(float)(m_offset+totalBytes) / (float)m_totalSize;
        m_totalBytes=totalBytes;

        QTime time2(0,0);
        time2=time2.addMSecs(time->elapsed());
        if (m_percent>0) {
            QTime time3(0,0);
            time3=time3.addMSecs((uint32_t)(time->elapsed()*(1/m_percent)));
            m_remain=time3.toString("hh:mm:ss");
        }

        m_percent*=100;
        m_progress->setProgress((int)m_percent);
        m_progress->setremain(time2.toString("hh:mm:ss") +" / " +m_remain);
        m_progress->setImage(m_player->getSaveImage()->getFileName());
    }
}

bool k9MP4Enc::isCanceled() {
    return (m_canceled || m_error);
}


void k9MP4Enc::getOutput(eStreamType streamType,int streamNumber,uchar *buffer,uint32_t size) {
    if (m_error)
        return;
    if ((streamType==NAV) && !m_mpeg2) {
        pci_t	 pci_pack;

        k9Ifo2::navRead_PCI(&pci_pack,buffer-14+ 0x2d);
        k9DVDChapter *ch=m_title->getChapterFromSector(pci_pack.pci_gi.nv_pck_lbn);
        bool chapterChanged=ch->getnum()!=m_currentChapter;
        m_currentChapter=ch->getnum();
        if (m_extractAudio && m_splitChapters && chapterChanged) {
            foreach( k9ConvertAudio *c, m_convertersToDelete) {
                if (!c->isRunning()) {
                    m_convertersToDelete.removeOne(c);
                    delete c;
                }

            }

            foreach (k9ConvertAudio *c,m_converters) {
                if (c)  {
                    c->end(false);
                }
            }
            buildAudioCmd(m_title);
        }
    }

    if (m_converters.contains(streamNumber+BASE_CONV_AUDIO) && (streamType==AUDIO)) {
        k9ConvertAudio *c=m_converters[BASE_CONV_AUDIO+streamNumber];
        if (!c->Error())
            c->addData(buffer,size);
        else {
            m_player->setAborted(true);
            m_error=true;
            m_msgError=i18n("An error occured while encoding the %1 stream",i18n("audio"));
            m_ErrorDetail=c->getOutput();
        }
    }

    if (streamType==NAV) {
        foreach(k9Subtitle2Pgm *sub,m_subtitles) {
            sub->addData(buffer,size);
        }

    } else if ((streamType==VIDEO) ||( !m_mpeg2 && !m_extractAudio && !m_extractMkv)) {
        k9ConvertAudio *c=m_converters[BASE_CONV_VIDEO];
        if (c)  {
            if (!c->Error())
                c->addData(buffer,size);
            else {
                m_player->setAborted(true);
                m_error=true;
                m_msgError=i18n("An error occured while encoding the %1 stream",i18n("video"));
                m_ErrorDetail=c->getOutput();
            }
        }
    }


    if ((streamType==SUBPICTURE) && (m_subtitles.contains(streamNumber))) {

        //k9ConvertAudio *c=m_converters[BASE_CONV_SUBTITLE+streamNumber];
        //c->addData(buffer,size);
        m_subtitles[streamNumber]->addData(buffer,size);
        //m_outputFile->write((char *) buffer,size);
    }
}


void k9MP4Enc::getOutput(uchar *buffer,uint32_t size) {
    if (m_mpeg2 ) {
        //waiting for free space in the fifo buffer (readen by mencoder process)
        m_fifo.addData(buffer,size);
        //Exits the eventloop executed by flush when fifo buffer is empty
        m_eventLoop->exit();
    }
}


void k9MP4Enc::Flush() {
    QIODevice *output;
    output=NULL;
    uchar buffer[40960];
    int size;
    do {
        while (m_fifo.count()>0) {
            size=m_fifo.readData(buffer,2048);

            if (m_mpeg2 && m_splitChapters && k9Cell::isNavPack(buffer)) {
                pci_t	 pci_pack;

                k9Ifo2::navRead_PCI(&pci_pack,buffer+ 0x2d);
                k9DVDChapter *ch=m_title->getChapterFromSector(pci_pack.pci_gi.nv_pck_lbn);

                if ((ch->getnum() != m_currentChapter) || !output) {
                    m_currentChapter=ch->getnum();
                    QString path=m_filename;

                    QString ext=m_filename.section(".",-1);
                    if (ext!="")
                        ext="."+ext;
                    path=m_filename.left(m_filename.length()-ext.length());
                    //path=QString("%1-chapter%2-cell%3%4").arg(path).arg(ichapterCells.key()).arg(ichapterCells.value()).arg(ext);
                    path=QString("%1-chapter%2%3").arg(path).arg(m_currentChapter).arg(ext);

                    if (m_outputFile)
                        m_outputFile->close();
                    m_outputFile=new QFile(path);
                    //removes an existing file;
                    m_outputFile->remove();
                    m_outputFile->open(QIODevice::WriteOnly);
                    output=m_outputFile;
                }
            }

            if (output)
                output->write((char*)buffer,size);
        }
        if (!m_player->terminated() && !m_canceled)
            m_eventLoop->exec();
    } while (!m_player->terminated() && !m_canceled && m_mpeg2);

    m_player->wait();
}



k9MP4Enc::~k9MP4Enc() {
    m_progress->close();
}



QMultiMap< int, k9ResultingFile* > k9MP4Enc::getResultingFiles() const {
    return m_resultingFiles;
}


void k9MP4Enc::setSplitChapters(bool theValue) {
    m_splitChapters = theValue;
}

