#ifndef KADU_CHAT_STYLES_H
#define KADU_CHAT_STYLES_H

#include <qstring.h>

/**
	Klasa okrelajca wygld styli
	wykorzystywanych w oknie rozmowy.
	\class ChatStyle
	\brief Styl okna Chat
**/
class ChatStyle
{
	private:
		QString FormatStringFull; /*!< acuch opisujcy peen styl */
		QString FormatStringPure; /*!< acuch opisujcy styl bez nagwka */

	public:
		/**
			Konstruktor stylu okna rozmowy
			\fn ChatStyle(const QString& format_string_full,
				const QString& format_string_pure)
			\param format_string_full peny styl okna
			\param format_string_pure styl bez nagwka
		**/
		ChatStyle(const QString& format_string_full,
			const QString& format_string_pure);

		/**
			Konstruktor stylu okna rozmowy
			\fn ChatStyle(const QString& format_string_full)
			\param format_string_full peny styl okna
		**/
		ChatStyle(const QString& format_string_full);

		/**
			\fn const QString& formatStringFull() const
			Zwraca acuch dla penego stylu
		**/
		const QString& formatStringFull() const;

		/**
			\fn const QString& formatStringPure() const
			Zwraca acuch dla stylu bez nagwka
		**/
		const QString& formatStringPure() const;

		/**
			Destruktor styli w oknie Chat
			\fn ~ChatStyle()
		**/
		virtual ~ChatStyle();
};

/**
	Klasa opisujca wygld stylu Kadu.
	\class KaduChatStyle
	\brief Styl Kadu dla okna Chat
**/
class KaduChatStyle : public ChatStyle
{
	public:
		/**
			Konstruktor stylu Kadu
			\fn KaduChatStyle()
		**/
		KaduChatStyle();
};

/**
	Klasa opisujca wygld stylu Hapi.
	\class HapiChatStyle
	\brief Styl Hapi dla okna Chat
**/
class HapiChatStyle : public ChatStyle
{
	public:
		/**
			Konstruktor stylu Hapi
			\fn HapiChatStyle()
		**/
		HapiChatStyle();
};

/**
	Klasa opisujca wygld stylu Irc.
	\class IrcChatStyle
	\brief Styl Irc dla okna Chat
**/
class IrcChatStyle : public ChatStyle
{
	public:
		/**
			Konstruktor stylu Irc
			\fn IrcChatStyle()
		**/
		IrcChatStyle();
};

/**
	Klasa opisujca wygld stylu stworzonego
	przez uytkownika.
	\class CustomChatStyle
	\brief Styl Custom dla okna Chat
**/
class CustomChatStyle : public ChatStyle
{
	public:
		/**
			Konstruktor stylu Custom
			\fn CustomChatStyle()
			\param full_style wasna skadnia stylu
		**/
		CustomChatStyle(const QString& full_style);
};

#endif
