#ifndef HINT_H
#define HINT_H

#include <qobject.h>
#include <qwidget.h>
#include <qlabel.h>
#include <qcolor.h>
#include <qfont.h>
#include <qevent.h>
#include <qstring.h>
#include <qpixmap.h>
#include <qlayout.h>

#include "gadu.h"

class Hint : public QHBoxLayout
{
	Q_OBJECT

	private:
		QLabel *icon;
		QLabel *label;
		QColor bcolor; //kolor ta
		unsigned int secs;
		unsigned int ident; //identyfikator
		UserListElements users;
		void enter();//rozjania dymek (to)
		void leave();//ustawia domylny kolor ta

	public:
		Hint(QWidget *parent, const QString &text, const QPixmap &pixmap, unsigned int timeout);
		~Hint();
		/**
			zwraca list uinw dotyczcych tego dymka
		**/
		UserListElements getUsers() const { return users; }

		/**
			zwraca identyfikator dymka
		**/
		unsigned int id() const {return ident;}

		void getData(QString &text, QPixmap &pixmap, unsigned int &timeout, QFont &font, QColor &fgcolor, QColor &bgcolor);

	protected:
		/**
			przy najechaniu myszk uruchamia enter(), przy opuszczeniu myszk dymka uruchamia leave()
			przy naciniciu ktrego przycisku myszy, emituje odpowiedni sygna *ButtonClicked(uint)
		**/
		bool eventFilter(QObject *obj, QEvent *ev);

	public slots:
		/**
			mina sekunda, zmniejsza licznik pozostaych sekund,
			zwraca true jeeli jeszcze pozosta czas
			false, gdy czas si skoczy
		**/
		bool nextSecond();
		/**
			gdy show==true pokazuje dymek
		**/
		void setShown(bool show);
		/**
			ustawia parametry dymka
			font - czcionka
			fgcolor - kolor czcionki
			bgcolor - kolor ta
			id - identyfikator dymka
			show - czy pokaza (teraz)
		**/
		void set(const QFont &font, const QColor &fgcolor, const QColor &bgcolor, unsigned int id, bool show = true);
		/**
			ustawia identyfikator
		**/
		void setId(unsigned int id) {ident = id;}
		/**
			ustawia list uinw dotyczcych tego dymka
		**/
		void setUsers(const UserListElements &i) { users = i; };

	signals:
		void leftButtonClicked(unsigned int id);
		void rightButtonClicked(unsigned int id);
		void midButtonClicked(unsigned int id);
};

#endif
