#ifndef __KADU_IWAIT4U_H
#define __KADU_IWAIT4U_H

#include <qobject.h>

#include "usergroup.h"
#include "misc.h"

struct LastNotify
{
	QTime time;
	UserListElement user;
};

class Waiting : public QObject
{
	Q_OBJECT
	
public:
	Waiting();
	~Waiting();

private:
	QValueList<LastNotify> notifies;
	
	int PosInMenu;			// pozycja, na jakiej znajdzie si wpis w menu kontekstowym;
	QStringList tracked, always_tracked;// lista osb, ktre sprawdzamy + lista na ktre zawsze czekamy
	UserListElement our_user;			// przechowuje nasz uin
	bool again_sound;

	
	void createGUI(void);
	void destroyGUI(void);
	
	void showMessage(const UserListElement &user, QString message);

/**
	TRACKED LIST
**/
	bool isOnTrackedList(QString id);
	void removeFromTrackedList(const QString id);
	void addToTrackedList(const QString id);
	void loadTrackedList(void);
	void saveTrackedList(void);


/**
	ALWAYS TRACKED
**/
	bool isAlwaysTracked(QString id);
	void loadAlwaysTrackedList(void);
	void saveAlwaysTrackedList(void);
	
private slots:
/**
	wywoywane w momencie nacinicia naszej pozycji w menu kontekstowym - checkbox, czy czekamy na uin.
**/
	void wait4Person(void);
/**
	uruchamia si si, przy wywietlaniu menu kontekstowego przy licie kontaktw.
**/
	void popupMenu(void);
/**
	wywoywane jak jaki uin zmieni status - sprawdza, czy to nie jest ten, na ktrego czekamy...
**/
	void userStatusChanged(UserListElement, QString, const UserStatus &, bool, bool);
	
	void checkOnConnection(void);
	
	void stopPlaingSound(void);
	void repeatSound(void);
	
	
/**
	GUI
**/
	void _Left(void);
	void _Right(void);
	void onCreateConfigDialog(void);
	void onApplyConfigDialog(void);
	void toggledUseSounds(bool);
	void toggledRepeatSounds(bool);
	void chooseSoundFile(void);
	void toggledMakeDelay(bool);
};
#endif
