#ifndef AUTO_HIDE_H
#define AUTO_HIDE_H

#include <qtimer.h>
/*!
 * This class provides autohiding Kadu's main window after preset time.
 * \brief This class provides autohiding Kadu's main window after preset time
 */
class AutoHide : public QObject
{
	Q_OBJECT
	public:
		/*!
		 * \brief Default constructor
		 * \param *parent parent object
		 * \param *name object's name
		 */
		AutoHide(QObject *parent = 0, const char *name = 0);

		//! Default destructor
		~AutoHide();
		
	protected:
		/*!
		 * \brief Prevents from hiding the window on keyboard/mouse event
		 * \param o Object
		 * \param e Event
		*/
		bool eventFilter(QObject *o, QEvent *e);
	
	private slots:
		void onCreateTab();
		void onApplyTab();
		void useAutoHideCheckBoxToggled(bool);
		void timerTimeoutSlot();
		
	private:
		QTimer timer;
		int idleTime;
};


#endif
