/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "powerkadu.h"
#include "kadu.h"
#include "config_dialog.h"
#include "config_file.h"
#include "debug.h"
#include "misc.h"
#include "qmessagebox.h"

#include "autostatus.h"

#include <qtimer.h>
#include <qpopupmenu.h>
#include <qspinbox.h>

Autostatus::Autostatus()
{
	menuID = powerKadu->mainMenu()->insertItem("&Autostatus", this, SLOT(onAutostatus()));
    
	timer = new QTimer;
	connect(timer, SIGNAL(timeout()), this, SLOT(changeStatus()));
	ConfigDialog::registerSlotOnCreateTab("PowerKadu", this, SLOT(onCreateTab()));

	create_gui();
}


Autostatus::~Autostatus()
{
	disconnect(timer, SIGNAL(timeout()), this, SLOT(changeStatus()));
	delete timer;

	ConfigDialog::unregisterSlotOnCreateTab("PowerKadu", this, SLOT(onCreateTab()));
	kill_gui();

	powerKadu->mainMenu()->removeItem(menuID);
}

void Autostatus::changeStatus()
{
	if(it == statusList.end())
		it = statusList.begin();

	autoStatus = config_file.readNumEntry("PowerKadu", "autoStatus");

	switch(autoStatus)
	{
		case 0:
			gadu->status().setOnline((*it));
			break;
		case 1:
			gadu->status().setBusy((*it)); 
			break;
		    
		case 2:
			gadu->status().setInvisible((*it));
			break;
	}
		it++;
}

void Autostatus::onCreateTab()
{
	ConfigDialog::getSpinBox("PowerKadu", "Time:")->setSuffix(" s");
}

void Autostatus::onAutostatus()
{
	if(powerKadu->mainMenu()->isItemChecked(menuID) == false)
	{

		currStat = gadu->currentStatus().index();
		currDesc = gadu->currentStatus().description();

		if (QFile::exists(config_file.readEntry("PowerKadu", "status_file_path")))
		{
			QFile file(config_file.readEntry("PowerKadu", "status_file_path"));
		
			QString desc;
			
			if (file.open(IO_ReadOnly))
			{
				QTextStream stream(&file);
		    
				while (!stream.atEnd())
				{
					desc = stream.readLine();
			
					if((desc!="") && (strlen(desc.latin1())<=70))
						statusList += desc;
				}
			}
		
			file.close();
		
			powerKadu->mainMenu()->setItemChecked ( menuID, true); 
		
			autoTime = config_file.readNumEntry("PowerKadu", "autostatus_time");

			timer->start((autoTime*1000));
		
			it = statusList.begin();
		}
		else
		{
			QMessageBox::information(this, "Autostatus", "File does not exist ! ");
		}
	}
	else
	{
		powerKadu->mainMenu()->setItemChecked ( menuID, false);
		timer->stop();
		gadu->status().setIndex(currStat, currDesc);
		statusList.clear();
	}
}

void Autostatus::create_gui()
{
	ConfigDialog::addVGroupBox("PowerKadu", "PowerKadu", QT_TRANSLATE_NOOP("@default", "Autostatus"));
	ConfigDialog::addLineEdit("PowerKadu", "Autostatus", QT_TRANSLATE_NOOP("@default", "Autostatus file:"),
			"status_file_path" ,ggPath("autostatus.list"), "Autostatus file path.");
	ConfigDialog::addSpinBox("PowerKadu", "Autostatus", QT_TRANSLATE_NOOP("@default", "Time:"),
			"autostatus_time", 0, 3600, 1, 30, "Insert time in seconds");
	ConfigDialog::addVRadioGroup("PowerKadu", "Autostatus", QT_TRANSLATE_NOOP("@default", "Status"), "autoStatus",
		toStringList(tr("Online"),tr("Busy"),tr("Invisible")), toStringList("0","1","2"), "1");
}

void Autostatus::kill_gui()
{
	ConfigDialog::removeControl("PowerKadu", "Status");
	ConfigDialog::removeControl("PowerKadu", "Time:");
	ConfigDialog::removeControl("PowerKadu", "Autostatus file:");
	ConfigDialog::removeControl("PowerKadu", "Autostatus");
}
