#ifndef POWERKADU_LINK_H
#define POWERKADU_LINK_H

#include <qlabel.h>

/*!
 * A hyperlink class for PowerKadu. When clicked on an object of this
 * class, openWebBrowser(QString url) (from misc.h) is called to open
 * the link.
 * \brief href PowerKadu link
 */
class PowerKaduLink : public QLabel
{
	Q_OBJECT
	public:
		/*!
		 * \brief Default constructor
		 * \param parent parent widget
		 * \param name object's name
		 */
		PowerKaduLink(QWidget *parent, const char *name = 0);

	private:
		~PowerKaduLink();
		
	protected:
		/*!
		 * \brief Opens the URL
		 * \param event mount event
		 */
		virtual void mousePressEvent(QMouseEvent *event);
		
		//! This is the URL pointing to PowerKadu documentation
		static QString targetURL;
};

#endif
