/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef OSD_CONFIGURATION_WIDGET_H
#define OSD_CONFIGURATION_WIDGET_H

#include <qcolor.h>
#include <qfont.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qspinbox.h>

#include "../notify/notify.h"

struct OSDProperties
{
	QString eventName;

	QString syntax;
	QFont font;
	QColor foregroundColor;
	QColor backgroundColor;
	QColor borderColor;
	unsigned int timeout;
	int maskEffect;
};

class OSDConfigurationWidget : public NotifierConfigurationWidget
{
	Q_OBJECT

	QMap<QString, OSDProperties> hintProperties;
	OSDProperties currentProperties;
	QString currentNotifyEvent;

	QLabel *preview;
	SelectFont *font;
	ColorButton *foregroundColor;
	ColorButton *backgroundColor;
	ColorButton *borderColor;
	QSpinBox *timeout;
	QComboBox *mask;
	QLineEdit *syntax;
	QLabel *warning;

private slots:
	void fontChanged(QFont font);
	void foregroundColorChanged(const QColor &color);
	void backgroundColorChanged(const QColor &color);
	void borderColorChanged(const QColor &color);
	void timeoutChanged(int timeout);
	void syntaxChanged(const QString &syntax);
	void maskChanged(int mask);

public:
	OSDConfigurationWidget(QWidget *parent = 0, char *name = 0);

	virtual void loadNotifyConfigurations() {}
	virtual void saveNotifyConfigurations();

	virtual void switchToEvent(const QString &event);

public slots:
	void setAllEnabled(bool enabled);
};

#endif
