#ifndef KADU_TABBAR_H
#define KADU_TABBAR_H

#include <qtabbar.h>

class QPainter;
class QToolButton;

/**
	Klasa ta jest odpowiedzialna za obsug zakadek grup kontaktw.
	\class KaduTabBar
	\brief Zakadki grup.
**/
class KaduTabBar : public QTabBar {
	Q_OBJECT
	public:
		/**
			\fn KaduTabBar(QWidget *parent = 0, const char *name = 0)
			Standardowy konstruktor.
			\param parent rodzic kontrolki.
			\param name nazwa kontrolki.
		**/
		KaduTabBar(QWidget *parent = 0, const char *name = 0);
		~KaduTabBar();

		/**
			\fn void layoutTabs()
			Ustawia zakadki w odpowiedniej pozycji.
		**/
		void layoutTabs();

		/**
			\fn QSize sizeHint() const
			Sugeruje odpowiedni rozmiar zakadek.
			\return sugerowany rozmiar.
		**/
		QSize sizeHint() const;

		/**
			\fn QSize minimumSizeHint() const
			Sugeruje minimalny rozmiar zakadek.
			\return sugerowany rozmiar.
		**/
		QSize minimumSizeHint() const;

		/**
			\fn int insertTab(QTab *newTab, int index = -1)
			Dodaje now zakadk.
			\param newTab wskanik do obiektu zakadki, ktr dodajemy.
			\param index pozycja, w ktr ma by wstawiona nowa zakadka. Domylnie -1 (na kocu).
		**/
		int insertTab(QTab *newTab, int index = -1);

		/**
			\fn void removeTab(QTab *t)
			Usuwa zakadk.
			\param t wskanik do obiektu zakadki, ktr usuwamy.
		**/
		void removeTab(QTab *t);

	public slots:

		/**
			\fn void setCurrentTab(QTab *tab)
			Ustawia dan zakadk jako bierzc.
			\param tab Wskanik do obiektu zakadki, ktr ustawiamy.
		**/
		void setCurrentTab(QTab *tab);

	private slots:
		void scrollTabsVert();

	protected:
		/**
			\fn void paint(QPainter *p, QTab *t, bool selected) const
			Rysuje dan zakadk.
			\param p urzdzenie rysujce.
			\param t wskanik do obiektu zakadki, ktr chcemy rysowa.
			\param selected informuje o tym, czy zakadka jest wybran (bierzc),
				czy jedn z zakadek zasonitych.
		**/
		void paint(QPainter *p, QTab *t, bool selected) const;

		/**
			\fn void updateArrowButtonsVert()
			Odwierza przyciski suce do przewijania listy zakadek (gdy jest duga).
		**/
		void updateArrowButtonsVert();

		/**
			\fn void makeVisibleVert(QTab *t)
			Wcza przyciski suce do przewijania listy zakadekna danej zakadce.
			\param t wskanik do obiektu zakadki, na ktrej wczamy przyciski.
			TODO: Nie jestem pewien czy ta metoda dokadnie to robi.
				Niech to poprawi kto, kto t metod pisa :)
		**/
		void makeVisibleVert(QTab *t);

		/**
			\fn void resizeEvent(QResizeEvent *)
			Metoda obsugujca zdarzenie zmiany rozmiaru paska zakadek.
			\param e wskanik obiektu opisujcego to zdarzenie.
		**/
		void resizeEvent(QResizeEvent *e);

		/**
			\fn void dragEnterEvent(QDragEnterEvent* e)
			Metoda obsugujca zdarzenie "przecignicia" nad list zakadek "podniesionego" wczeniej elementu.
			\param e wskanik obiektu opisujcego to zdarzenie.
		**/
		void dragEnterEvent(QDragEnterEvent* e);

		/**
			\fn void dropEvent(QDropEvent* e)
			Metoda obsugujca zdarzenie "upuszczenia" nad list zakadek "podniesionego" wczeniej elementu.
			\param e wskanik obiektu opisujcego to zdarzenie.
		**/
		void dropEvent(QDropEvent* e);

		/**
			\var QPtrList<QTab> *lstatic2
			Lista wskanikw do obiektw zakadek.
		**/
		QPtrList<QTab> *lstatic2;

		/**
			\var bool vertscrolls
			Informuje o tym, czy pasek zakadek jest ju na tyle dugi, ze trzeba go przewija.
		**/
		bool vertscrolls;

		/**
			\var QToolButton *upB
			Wskanik do obiektu przycisku przewijajcego zakadki w gr.
		**/
		QToolButton *upB;

		/**
			\var QToolButton *downB
			Wskanik do obiektu przycisku przewijajcego zakadki w d.
		**/
		QToolButton *downB;
};

#endif
