/*
 * powerpc/trampolines.c
 *
 */

asm(
	""
	".text								\n"
	".align  2							\n"
	".globl _powerpc_do_fixup_trampoline				\n"
	"								\n"
"_powerpc_do_fixup_trampoline:						\n"
	"								\n"
	"# Function prologue: establish a minimum stack frame. We don't	\n"
	"# save lr - it was already saved at 8(r1) by the trampoline	\n"
	"# code. However, we must save r3 and r4, as we will use them	\n"
	"# to call soft_fixup_trampoline().				\n"
	"stwu r1, -192(r1)						\n"
	"stw  r3, 56(r1)						\n"
	"stw  r4, 60(r1)						\n"
	"stw  r5, 64(r1)						\n"
	"stw  r6, 68(r1)						\n"
	"stw  r7, 72(r1)						\n"
	"stw  r8, 76(r1)						\n"
	"stw  r9, 80(r1)						\n"
	"stw  r10, 84(r1)						\n"
	"								\n"
	"stfd  f1, 88(r1)						\n"
	"stfd  f2, 96(r1)						\n"
	"stfd  f3, 104(r1)						\n"
	"stfd  f4, 112(r1)						\n"
	"stfd  f5, 120(r1)						\n"
	"stfd  f6, 128(r1)						\n"
	"stfd  f7, 136(r1)						\n"
	"stfd  f8, 144(r1)						\n"
	"stfd  f9, 152(r1)						\n"
	"stfd  f10, 160(r1)						\n"
	"stfd  f11, 168(r1)						\n"
	"stfd  f12, 176(r1)						\n"
	"stfd  f13, 184(r1)						\n"
	"								\n"
	"# Build function call to soft_fixup_trampoline(). This function\n"
	"# requires two arguments: a 'Method *m' and a 'void **where'.	\n"
	"# They can be found immediately after the trampoline code which\n"
	"# took us here - that is, at (lr) and 4(lr)			\n"
	"mflr r4							\n"
	"lwz  r3, 0(r4)							\n"
	"lwz  r4, 4(r4)							\n"
	"								\n"
	"# Call soft_fixup_trampoline(). Return value will be in r3, 	\n"
	"# which is the address of the translated native code.		\n"
	"								\n"
	"bl _soft_fixup_trampoline					\n"
	"								\n"
	"# Save return value in ctr, so that we can jump there at the	\n"
	"# end of this function						\n"
	"mtctr r3							\n"
	"								\n"
	"# Restore r3 and r4 (the original arguments to the native	\n"
	"# method that we overwrote to call soft_fixup_trampoline)	\n"
	"lwz  r3, 56(r1)						\n"
	"lwz  r4, 60(r1)						\n"
	"lwz  r5, 64(r1)						\n"
	"lwz  r6, 68(r1)						\n"
	"lwz  r7, 72(r1)						\n"
	"lwz  r8, 76(r1)						\n"
	"lwz  r9, 80(r1)						\n"
	"lwz  r10, 84(r1)						\n"
	"								\n"
	"lfd  f1, 88(r1)						\n"
	"lfd  f2, 96(r1)						\n"
	"lfd  f3, 104(r1)						\n"
	"lfd  f4, 112(r1)						\n"
	"lfd  f5, 120(r1)						\n"
	"lfd  f6, 128(r1)						\n"
	"lfd  f7, 136(r1)						\n"
	"lfd  f8, 144(r1)						\n"
	"lfd  f9, 152(r1)						\n"
	"lfd  f10, 160(r1)						\n"
	"lfd  f11, 168(r1)						\n"
	"lfd  f12, 176(r1)						\n"
	"lfd  f13, 184(r1)						\n"
	"								\n"
	"# Restore previous stack pointer				\n"
	"addi r1, r1, 192						\n"
	"								\n"
	"# Restore Link Register before invoking native method, so that	\n"
	"# it returns to the right place.				\n"
	"lwz  r0, 8(r1)							\n"
	"mtlr r0							\n"
	"								\n"
	"# Jump to the native method address that we obtained as a	\n"
	"# return value of soft_fixup_trampoline()			\n"
	"bctr"
);
