# semaphore.m4 serial 1
dnl Copyright(c) 2004 Guilhem Lavaux
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

AC_DEFUN([KAFFE_CHECK_SEMAPHORE],
[
  AC_CHECK_HEADERS([semaphore.h])
  AC_MSG_CHECKING([for working semaphores])
  old_LDFLAGS="$LDFLAGS"
  old_CFLAGS="$CFLAGS"
  LDFLAGS="$LDFLAGS $PTHREAD_LIBS"
  CFLAGS="$CFLAGS $PTHREAD_CFLAGS"

  AC_RUN_IFELSE(AC_LANG_PROGRAM(
[
#include <semaphore.h>
int ret;
sem_t semtest;
],[
ret = sem_init(&semtest, 0, 0);
return (ret < 0) ? 1 : 0;
]),[AC_MSG_RESULT(ok)],
  [
	AC_DEFINE(NEED_REPLACEMENT_SEMAPHORES, 1, [Defined if we need a replacement for semaphores])
	AC_MSG_RESULT(not implemented)
  ],
  [
	AC_DEFINE(NEED_REPLACEMENT_SEMAPHORES, 1, [Defined if we need a replacement for semaphores])
	AC_MSG_RESULT(cross compiling)
  ])

  LDFLAGS="$old_LDFLAGS"
  CFLAGS="$old_CFLAGS"
])
