#include <stdlib.h>
#include <unistd.h>
#include <pwd.h>
#include <sys/types.h>

#include <qobject.h>
#include <qfile.h>

#include <kstandarddirs.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kglobal.h>
#include <kconfig.h>
#include <kdebug.h>

#include "main.h"

#include "pref.h"

kfishPref *kfishPref::s_prefs = 0L;

/*{
                                            { "swordfish", fishInfo("swordfish", "swordfish.png", 155, 55, 3, Qt::Vertical) }
                                        };*/

kfishPref *kfishPref::prefs()
{
    if( !s_prefs )
        s_prefs = new kfishPref;
    return s_prefs;
}

kfishPref::kfishPref()
{
    m_width = 5;
    m_height = 5;
    m_fishSelNum. setAutoDelete(true);
    config = kfishApp -> config();
    load();
}


kfishPref::~kfishPref()
{
}

fishInfoStr* kfishPref::getFishInfo()
{
    
    static fishInfoStr fishInfo[] = { 
                              { "swordfish", "swordfish.png", 155, 55, 3, Qt::Vertical },
                              { "ernest",    "ernest.png", 99, 80, 3, Qt::Vertical },
                              { "hunter",    "hunter.png", 141, 88, 3, Qt::Vertical },
                              { "tourtle",   "fillmore.png", 128, 116, 12, Qt::Vertical },
                              { "greeny",    "fish3.png", 59, 41, 3, Qt::Vertical },
                              { "rayitas",   "fish4.png", 86, 27, 3, Qt::Vertical },
                              { "orangy",    "fish6.png", 134, 80, 3, Qt::Vertical },
                              { "lori",      "lori.png", 73, 65, 3, Qt::Vertical },
                              { "squid",     "squid.png", 92, 55, 3, Qt::Vertical },
                              { "nomore",    "lalalalaaaaaaaaaaa(broken glasses)", 0, 0, 0, Qt::Vertical }
                             };
    return fishInfo;
}

void kfishPref::load()
{
    config->setGroup("kAquarium General");
    // MAIN
    m_numBubble = config->readNumEntry("Number of Bubbles", 20);
    m_widthSpace = config->readNumEntry("Width Space on Horizontal", 60);
    m_fishScale = config->readNumEntry("Scale", 30);
    
    m_fishSel = config->readBoolEntry("Fish Select", false);
    m_fishRan = config->readBoolEntry("Fish Random", true);
    m_fishNumber = config->readNumEntry("fish number", 10);
    
    fishInfoStr *duh = getFishInfo();
    

    m_fishSelNum. clear();
    for(int i=0; duh[i].name != "nomore"; i++)
    {
        m_fishSelNum.replace(duh[i]. name, new QString(QString("%1").arg(config->readNumEntry(duh[i]. name, 0))));
    }
/*    bool ok;
    QDictIterator<QString> it( m_fishSelNum );
    for( ; it.current(); ++it ) {
        kdDebug(1210) << it.currentKey() << ": " << *(it.current()) << " Num:" << it.current()->toInt(&ok, 10) << endl;
    }*/
    
    emit changePref();
}

void kfishPref::write()
{
    kdDebug(1210) << "void kfishPref::write()" << endl;
    config->setGroup("kAquarium General");
    // MAIN
    config->writeEntry("Fish number", m_fishNumber);
    config->writeEntry("Number of Bubbles",m_numBubble);
    config->writeEntry("Width Space on Horizontal",m_widthSpace);
    config->writeEntry("Scale", m_fishScale);
    config->writeEntry("Fish Select", m_fishSel);
    config->writeEntry("Fish Random", m_fishRan);
    
    QDictIterator<QString> it( m_fishSelNum );
    bool ok;
    for( ; it.current(); ++it )
    {
        config->writeEntry(it.currentKey(), it.current()->toInt(&ok, 10));
    }
    
    config->sync();
    emit changePref();
}

void kfishPref::emitChangePref()
{
    emit changePref();
}
