/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;

public class ExtractZip
extends TimerTask {
    private Enumeration entries;
    private int size;
    private int counterzipentries;
    private Timer timer;
    private FileOutputStream writeStream = null;
    private InputStream readStream = null;
    private ZipFile currentZipArchive = null;
    private boolean alwaysoverwrite;
    private File extractdirectory;
    private byte[] buffer = new byte[1024];
    private int nbextractedfiles;
    private String zipfilename;
    private JFrame frameparentwindow;
    private ProgressMonitor progressbar = null;
    private ResourceBundle i18nmessages;

    public ExtractZip(ResourceBundle resourceBundle) {
        this.i18nmessages = resourceBundle;
    }

    private String getLocalizedDate(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy hh:mma", Locale.getDefault());
        return simpleDateFormat.format(date);
    }

    public void extract(String string, File file, JFrame jFrame) {
        block4: {
            this.extractdirectory = file;
            this.zipfilename = string;
            this.frameparentwindow = jFrame;
            this.alwaysoverwrite = false;
            try {
                this.currentZipArchive = new ZipFile(new File(string));
                this.size = this.currentZipArchive.size();
                boolean bl = false;
                this.entries = this.currentZipArchive.entries();
                this.counterzipentries = 0;
                this.nbextractedfiles = 0;
                this.timer = new Timer();
                this.timer.scheduleAtFixedRate((TimerTask)this, 0L, 1L);
                this.progressbar = new ProgressMonitor(this.frameparentwindow, this.i18nmessages.getString("Extracting_files"), this.i18nmessages.getString("Preparing"), 0, this.size);
                this.progressbar.setMillisToPopup(0);
            }
            catch (Exception exception) {
                System.out.println(exception);
                if (this.currentZipArchive == null) break block4;
                try {
                    this.currentZipArchive.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public void run() {
        block16: {
            ZipEntry zipEntry = (ZipEntry)this.entries.nextElement();
            if (zipEntry.isDirectory()) {
                ++this.counterzipentries;
                return;
            }
            String string = zipEntry.getName();
            if (!string.startsWith("Data/")) {
                ++this.counterzipentries;
                return;
            }
            string = string.substring(5);
            this.progressbar.setProgress(this.counterzipentries);
            this.progressbar.setNote(string);
            if (this.progressbar.isCanceled()) {
                this.timer.cancel();
                return;
            }
            try {
                int n;
                Object[] objectArray;
                this.readStream = this.currentZipArchive.getInputStream(zipEntry);
                File file = new File(this.extractdirectory, string);
                Date date = new Date(zipEntry.getTime());
                if (!this.alwaysoverwrite && file.exists()) {
                    objectArray = new Object[]{this.i18nmessages.getString("Yes"), this.i18nmessages.getString("Yes_to_all"), this.i18nmessages.getString("No")};
                    int n2 = JOptionPane.showOptionDialog(this.frameparentwindow, this.i18nmessages.getString("Warning_shall_I_overwrite") + " " + file.getName() + "\n" + this.getLocalizedDate(new Date(file.lastModified())) + ",  " + file.length() + this.i18nmessages.getString("Bytes") + "\n" + this.i18nmessages.getString("with_this_file_in_archive") + this.getLocalizedDate(date) + ",  " + new Long(zipEntry.getSize()) + this.i18nmessages.getString("Bytes"), this.i18nmessages.getString("Warning"), -1, 2, null, objectArray, objectArray[0]);
                    if (n2 == 2) {
                        ++this.counterzipentries;
                        return;
                    }
                    if (n2 == 1) {
                        this.alwaysoverwrite = true;
                    }
                }
                if ((objectArray = new File(file.getParent())) != null && !objectArray.exists()) {
                    objectArray.mkdirs();
                }
                this.writeStream = new FileOutputStream(file);
                while ((n = this.readStream.read(this.buffer, 0, this.buffer.length)) != -1) {
                    this.writeStream.write(this.buffer, 0, n);
                }
                this.writeStream.close();
                file.setLastModified(date.getTime());
                ++this.counterzipentries;
                ++this.nbextractedfiles;
                if (this.counterzipentries == this.size) {
                    this.EndExtractProcess();
                }
            }
            catch (Exception exception) {
                System.out.println(exception);
                if (this.writeStream != null) {
                    try {
                        this.writeStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (this.readStream == null) break block16;
                try {
                    this.readStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private void EndExtractProcess() {
        this.timer.cancel();
        this.progressbar.close();
        try {
            this.currentZipArchive.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        JOptionPane.showMessageDialog(this.frameparentwindow, this.i18nmessages.getString("Successfully_extracted") + " " + this.nbextractedfiles + (this.nbextractedfiles > 1 ? this.i18nmessages.getString("files") : this.i18nmessages.getString("file")) + "\n" + this.i18nmessages.getString("from") + " " + this.zipfilename + "\n" + "into" + " " + this.extractdirectory.getPath(), this.i18nmessages.getString("KArchiver_SelfExtract_archive"), 1);
        System.exit(0);
    }
}

