/***************************************************************************
                          cajoutfichiers.cpp  -  description
                             -------------------
    begin                : Thu Jun 3 1999
    copyright            : (C) 2000 by Eric Coquelle
    email                : coquelle@caramail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qpixmap.h>
#include <qlayout.h>

#include "caddfilestoarchive.h"

#include <kiconloader.h>
	
	
CAddFilesToArchive::CAddFilesToArchive(QDialog* parent,const char* name)
:QDialog( parent, name, TRUE )
{
   KIconLoader icon;
   setIcon(icon.loadIcon("karchiver",KIcon::Small));
   setCaption(i18n("Add files to current archive"));
   
   QGridLayout *grid1 = new QGridLayout(this,8,3,15,7);
   listView = new KListView( this, "ListView_AddFiles" );
   listView->addColumn( i18n("Choose files:"), -1 );
   listView->setSelectionModeExt(KListView::Single);
   grid1->addMultiCellWidget(listView,0,7,0,0);

   directory=new Directory(listView);
   directory->setDisplayFiles(TRUE);
   directory->setOpen(TRUE);
   connect(listView, SIGNAL(executed ( QListViewItem *)), this, SLOT(slotSelectionChanged(QListViewItem*)));

   QButtonGroup* qtarch_ButtonGroup;
   qtarch_ButtonGroup = new QButtonGroup( this, "ButtonGroup" );
   qtarch_ButtonGroup->setFocusPolicy( QWidget::NoFocus );
   qtarch_ButtonGroup->setBackgroundMode( QWidget::PaletteBackground );
   qtarch_ButtonGroup->setFrameStyle( 49 );
   qtarch_ButtonGroup->setLineWidth( 1 );
   qtarch_ButtonGroup->setMidLineWidth( 0 );
   qtarch_ButtonGroup->QFrame::setMargin( 0 );
   qtarch_ButtonGroup->setTitle( i18n("Kind of Operation:") );
   qtarch_ButtonGroup->setAlignment( 1 );
   qtarch_ButtonGroup->setExclusive( FALSE );
   grid1->addMultiCellWidget( qtarch_ButtonGroup,0,2,1,2);

   QGridLayout *grid2 = new QGridLayout(qtarch_ButtonGroup,3,1,15,7); 
   qtarch_RadioAdd = new QRadioButton( qtarch_ButtonGroup, "RadioAdd" );
   qtarch_RadioAdd->setFocusPolicy( QWidget::TabFocus );
   qtarch_RadioAdd->setBackgroundMode( QWidget::PaletteBackground );
   qtarch_RadioAdd->setText( i18n("Add files") );
   qtarch_RadioAdd->setAutoRepeat( FALSE );
   qtarch_RadioAdd->setAutoResize( FALSE );
   qtarch_RadioAdd->setChecked( TRUE );
   grid2->addWidget(qtarch_RadioAdd,0,0);


   qtarch_RadioUpdate = new QRadioButton( qtarch_ButtonGroup, "RadioUpdate" );
   qtarch_RadioUpdate->setFocusPolicy( QWidget::TabFocus );
   qtarch_RadioUpdate->setBackgroundMode( QWidget::PaletteBackground );
   qtarch_RadioUpdate->setText( i18n("Update files") );
   qtarch_RadioUpdate->setAutoRepeat( FALSE );
   qtarch_RadioUpdate->setAutoResize( FALSE );
   qtarch_RadioUpdate->setChecked( FALSE );
   grid2->addWidget(qtarch_RadioUpdate,1,0);

   qtarch_Motif = new QPushButton( this, "Button_Dialog" );
   grid1->addMultiCellWidget(qtarch_Motif,3,3,1,2);
   qtarch_Motif->setText( i18n("Use a dialog box") );
   connect(qtarch_Motif,SIGNAL(clicked()),SLOT(slotGetFilesFromDialogBox()));

   qtarch_CheckBox = new QCheckBox( this, "CheckBox" );
   grid1->addMultiCellWidget(qtarch_CheckBox,4,4,1,2);
   qtarch_CheckBox->setFocusPolicy( QWidget::TabFocus );
   qtarch_CheckBox->setBackgroundMode( QWidget::PaletteBackground );
   qtarch_CheckBox->setText( i18n("Delete source files") );
   qtarch_CheckBox->setAutoRepeat( FALSE );
   qtarch_CheckBox->setAutoResize( FALSE );
   qtarch_CheckBox->setChecked( FALSE );

   QPushButton* qtarch_PushOK;
   qtarch_PushOK = new QPushButton( this, "PushOK" );
   grid1->addWidget(qtarch_PushOK,7,1);
   qtarch_PushOK->setFocusPolicy( QWidget::TabFocus );
   qtarch_PushOK->setBackgroundMode( QWidget::PaletteBackground );
   qtarch_PushOK->setText( i18n("OK") );
   qtarch_PushOK->setAutoRepeat( FALSE );
   qtarch_PushOK->setAutoResize( FALSE );
   qtarch_PushOK->setToggleButton( FALSE );
   qtarch_PushOK->setDefault( FALSE );
   qtarch_PushOK->setAutoDefault( FALSE );
   qtarch_PushOK->setIsMenuButton( FALSE );
   connect(qtarch_PushOK,SIGNAL(clicked()),SLOT(OK()));

   QPushButton* qtarch_PushCancel;
   qtarch_PushCancel = new QPushButton( this, "PushCancel" );
   grid1->addWidget(qtarch_PushCancel,7,2);
   qtarch_PushCancel->setText( i18n("Cancel") );
   connect(qtarch_PushCancel,SIGNAL(clicked()),SLOT(Cancel()));

   qtarch_LineFichiers = new QTextEdit( this, "LineFichiers" );
   grid1->addMultiCellWidget( qtarch_LineFichiers ,5,6,1,2);
   
   qtarch_ButtonGroup->insert( qtarch_RadioAdd );
   qtarch_ButtonGroup->insert( qtarch_RadioUpdate );
   
   resize( 400,305 );
   path="";
}


CAddFilesToArchive::~CAddFilesToArchive()
{
}

void CAddFilesToArchive::rebuildPath(QListViewItem *l)
{
	if(l->depth()!=0)
	{
		path="/"+path;
		path=l->text(0)+path;
		rebuildPath(l->parent());
	}
	else
	{
		path="/"+path;
		int i;
		i=0;

        for ( QStringList::Iterator f=filelist.begin(); f!=filelist.end(); ++f )
        {
		    if(*f==path)
            {
              filelist.remove(*f);
              qtarch_LineFichiers->removeParagraph(i);
              path="";
              return;
            }
		    i++;
		}
		filelist.append(path);
		qtarch_LineFichiers->insertParagraph(path, -1);
		path="";
	}
}

QStringList CAddFilesToArchive::getFiles()
{
	return filelist;
}

void CAddFilesToArchive::OK()
{
	done(0);
}

void CAddFilesToArchive::Cancel()
{
	done(1);
}

int CAddFilesToArchive::getAction()
{
  if(qtarch_RadioAdd->isChecked())
   return ADD_AND_REPLACE_FILES;
  else if(qtarch_RadioUpdate->isChecked())
   return UPDATE_FILES;
  return -1;
}

/* Return true if source files should be removed */
bool CAddFilesToArchive::hasToRemoveFiles()
{
	return qtarch_CheckBox->isChecked();
}

void CAddFilesToArchive::slotGetFilesFromDialogBox()
{
  QStringList filelistfromdialogbox;
		
  filelistfromdialogbox=KFileDialog::getOpenFileNames(QDir::homeDirPath(), "", 0, i18n("Select the files to add in archive"));

  filelist+=filelistfromdialogbox;		

  for (QStringList::Iterator f = filelistfromdialogbox.begin(); f!=filelistfromdialogbox.end(); ++f)
    qtarch_LineFichiers->insertParagraph(*f, -1);
}

void CAddFilesToArchive::slotSelectionChanged(QListViewItem* l)
{
   rebuildPath(l);

   if(l->pixmap(0)!=NULL)//It is a directory, so let's remove all its childs
   {
     int number=filelist.count();
     int i=0;
     QString ref=*filelist.at(number-1);
     
     while(i<number-1)
     {
       if((*filelist.at(i)).startsWith(ref))
       {
         filelist.remove(*filelist.at(i));
         qtarch_LineFichiers->removeParagraph(i);
         number--;
       }
       else
         i++;
     }
   }
}

/*Disable the Update radio when none archive is loaded*/
void CAddFilesToArchive::setUpdateAvailable(bool b)
{
  qtarch_RadioUpdate->setEnabled(b);
}

#include "caddfilestoarchive.moc"
