/***************************************************************************
                          cajoutfichiers.h  -  description
                             -------------------
    begin                : Thu Jun 3 1999
    copyright            : (C) 2000 by Eric Coquelle
    email                : coquelle@caramail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _CADDFILESTOARCHIVE_
#define _CADDFILESTOARCHIVE_

#include <qdialog.h>
#include <qdir.h>
#include <qfiledialog.h>
#include <qlistview.h>
#include <qradiobutton.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qcheckbox.h>
#include <qbuttongroup.h>
#include <qtextedit.h>

#include <kapp.h>
#include <klocale.h>
#include <kfiledialog.h>
#include <klistview.h>

#include "dirview.h"
#include "resource.h"

/* The CAddFilesToArchive class. It provides a dialog box
	for adding some files to currently loaded archive. It
	 returns a QStrList containing the files to be added,
         and getAction to tell if the files should replace or update
         archive's data*/
	
class CAddFilesToArchive : public QDialog
{
    Q_OBJECT

public:

    CAddFilesToArchive
    (
        QDialog *parent = 0,
        const char* name = 0
    );

    virtual ~CAddFilesToArchive();

        /*Returns a list of all files that have to be added to current archive*/
	QStrList getFiles();
        /*Return ADD_AND_REPLACE_FILES -0- to replace files in current archive, or UPDATE_FILES -1-*/
	int getAction();
	/* Return true if source files should be removed */
	bool hasToRemoveFiles();

private:
  void rebuildPath(QListViewItem*);
  
private slots:
	void OK();
	void Cancel();
	void selectionneMotif(int);
        void slotSelectionChanged(QListViewItem*);
        void slotGetFilesFromDialogBox();

  private:
    KListView* listView;
	Directory *directory;
	QRadioButton* qtarch_RadioAdd;
	QRadioButton* qtarch_RadioUpdate;
	QPushButton* qtarch_Motif;
	QCheckBox* qtarch_CheckBox;
	QTextEdit* qtarch_LineFichiers;
	QString path;
	QStrList filelist;
};

#endif
