/***************************************************************************
                          carj.h  -  description
                             -------------------
    begin                : Sat Dec 2 2000
    copyright            : (C) 2000 by Eric Coquelle
    email                : coquelle@caramail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CARJ_H
#define CARJ_H

#include <carchive.h>

/**This class will manage the .arj archives
  *@author Eric Coquelle
  */

class CArj : public CArchive  {
Q_OBJECT
public: 
	CArj();
	~CArj();
  /** this method will launch the right compressor
		* to list the file contents
		* It will then launch the right method to display
		* the content in the listview */
  void displayArchiveContent();
	/** Upon the kind of archive, choose the right
		*uncompressor and extract all or some files
		*extractall = 9: extract to karchiveur's temp directory (for viewing)
		*extractall = 1: extract all selected files
	*/
 void extractArchive(QString &extractpath, int extractall, QString &filetoextract);
 void addFilesToArchive( QStringList filestoadd, bool removeoriginalfiles, int action, QString relativepath);
 void createArchive(QString nameofarchive, QStringList filestoadd, QString relativepath=NULL);
 
protected: // Protected methods
  /** display in a listview the content of the current
		* arj archive. This method examines the stdout of
		* unarj to sort useful infos for the listview */
  void displayArjArchiveContent(FILE* flot);
  /* Overloaded method */
	void displayArjArchiveContent( const char* ligne);
	
protected slots:
	void endProcess(KProcess*);
	/** we recive some informations through the standard
		* output of the process */
	void haveSdtOut(KProcess *prpc, char *buffer, int length);
	void haveSdtOutExtract(KProcess *prpc, char *buffer, int length);
	
private:
	bool headerremoved;
	bool finished;
};

#endif
