/***************************************************************************
                          cgz.cpp  -  description
                             -------------------
    begin                : Sat Dec 2 2000
    copyright            : (C) 2000 by Eric Coquelle
    email                : coquelle@caramail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "cgz.h"
#include <kdebug.h>
#include <qfileinfo.h>

CGz::CGz(){
  CArchive();

  connect(&processextract,SIGNAL(receivedStdout(KProcess*, char*, int)),this,SLOT(haveSdtOutExtract(KProcess*,char*,int)));
  connect(&processextract,SIGNAL(processExited (KProcess*)),this,SLOT(endProcess(KProcess*)));
  connect(&processextract, SIGNAL(receivedStderr(KProcess *, char *, int)),this, SLOT(haveSdtErrExtract(KProcess*,char*,int)));
}

CGz::~CGz(){
}

/** this method will launch the right compressor
to list the file contents
It will then launch the right method to display
the content in the listview */
void CGz::displayArchiveContent(){
	QString name;
	CListViewItem *li;
        
        initializeReadingArchive();

	name=archiveName;
	name=name.left(name.findRev('.'));
	li=new CListViewItem(list,name.right(name.length()-name.findRev('/')-1),"","","","","",name.left(name.findRev('/')+1));
	setIcon(name.right(name.length()-name.findRev('/')-1),"",li);
	emit(archiveReadEnded());
}

/** Upon the kind of archive, choose the right
	*uncompressor and extract all or some files
	*@toutextraire = 9: extract to karchiveur's temp directory (for viewing)
	*@toutextraire = 1: extract all selected files
	*/
void CGz::extractArchive(QString & extractpath, int , QString & ){
 	QString directoryOption;
 	QString nomextrait;
 	QString fichiersaextraire;
 	QString str;

        errors.clear();
	directoryOption="";
	fichiersaextraire="";
	counter=0;
	progressbar->reset();
	progressbar->setTotalSteps(list->childCount());

	processextract.clearArguments();
	processextract << "gzip";
	processextract << "-dc";

	if(overwrite)
		processextract << "-f";

 	processextract << archiveName;

		if(extractpath[extractpath.length()-1]!='/')
 			extractpath+="/";
 		str=archiveName;
 		str=str.left(str.findRev('.'));
 		str=str.right(str.length()-str.findRev('/')-1);
 		str=extractpath+str;
kdDebug() << QString("Gz::extract: fopen %1 extr path %2\n").arg(str).arg(extractpath);
 		fileIO=fopen(str,"w");
 		if(fileIO==NULL)
 			return;
 		//The GZIP ans BZIP2 are extracted through StdOut
 		if(processextract.start(KProcess::NotifyOnExit, KProcess::AllOutput)==FALSE)
		  kdDebug()<<("\n*PB PROCESS*\n");
}

/** we recive some informations through the standard
output of the process */
void CGz::haveSdtOutExtract(KProcess *, char *buffer, int length){
 	counter++;
 	fwrite(buffer,sizeof(char),length,fileIO);
 	QString s=i18n("Running compressor...");
 	switch(counter/4%8)
 	{
 		case 0:
 			s+="-";
 			break;
 		case 1:
 			s+="/";
 			break;
 		case 2:
 			s+="|";
 			break;
 		case 3:
 			s+="\\";
 			break;
 		case 4:
 			s+="-";
 			break;
 		case 5:
 			s+="/";
 			break;
 		case 6:
 			s+="|";
 			break;
 		case 7:
 			s+="\\";
 			break;
		}
 	//displayMessage(s);
}

/** The current process ended */
void CGz::endProcess(KProcess*){
  kdDebug()<<("Process CGz ENDED\n");
  
  fclose(fileIO);
	emit(archiveReadEnded());
}

/** Create a gzip archive
@param  nameofarchive: the name of the pure .tar archive
@param param: list of files to add
@param relativepath: include only filenames, without their path */
void CGz::createArchive(QString nameofarchive, QStringList filestoadd, QString ){
  KProcess process;
  if(filestoadd.count()!=1)
  {
    //displayMessage(i18n("Cannot create such archive !"));
    //led->setColor(QColor("red"));
    emit(archiveReadEnded());
    return;
  }
  fileIO=fopen(nameofarchive,"w");
  if(fileIO==NULL)
    return;

  processextract.clearArguments();
  processextract << "gzip";
  processextract << "-c";
  processextract << QString("-%1").arg(compressrate);
  processextract << *filestoadd.at(0);
  processextract.start(KProcess::NotifyOnExit);
}

#include "cgz.moc"
