/***************************************************************************
                          chistorique.cpp  -  description
                             -------------------
    begin                : Wed Aug 23 2000
    copyright            : (C) 2000 by Eric Coquelle
    email                : coquelle@caramail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "chistorique.h"

CHistory::CHistory(){
	maxElements=0;
}

CHistory::~CHistory(){
}

/** return an array that contains all the stored
elements */
QStrList CHistory::getElements(){
	return elements;
}

/** Add an item to the array. This method will
check if the element is not present in the
array, otherwise, do nothing */
void CHistory::addElement(QString element){
	if(elements.contains(element)==0)
	{
		elements.insert(0, element);
		if(elements.count()>maxElements)
			elements.removeLast();
	}
}

/** return the current array element, i.e. its
first one */
QString CHistory::getCurrentElement(){
	return elements.first();
}

/** set the history size to max */
void CHistory::setMaxElements(int max){
	maxElements=(unsigned int)max;
}

/** return the maximal history size */
int CHistory::getMaxElements(){
	return (int)maxElements;
}

/** return the element at position idx */
QString CHistory::getElementAt(int idx){
	return elements.at(idx);
}

/** return the number of elements in the array */
int CHistory::getNumberOfElements(){
	return elements.count();
}

/** set the array elements to list */
void CHistory::setElements(QStrList list){
	elements=list;
}
