/***************************************************************************
                          ctarbz2.h  -  description
                             -------------------
    begin                : Sat Dec 2 2000
    copyright            : (C) 2000 by Eric Coquelle
    email                : coquelle@caramail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CTARBZ2_H
#define CTARBZ2_H

#include "ctar.h"

/**This class will manage the .tar.bz2 archives
  *@author Eric Coquelle
  */


class CTarBz2 : public CTar  {
Q_OBJECT
public: 
	CTarBz2();
	~CTarBz2();
  /** this method will launch the right compressor
  to list the file contents
  It will then launch the right method to display
  the content in the listview */
  void displayArchiveContent();
	/** Upon the kind of archive, choose the right
	*uncompressor and extract all or some files
	*@toutextraire = 9: extract to karchiveur's temp directory (for viewing)
	*@toutextraire = 1: extract all selected files
	*/
	void extractArchive(QString & extractpath, int extractall, QString & filetoextract);
	/** delete @param filestodelete from current archive */
	void removeFilesFromArchive( QStringList filestodelete );
  /** Add some files to the archive
  @param filestoadd : list of files to add
  @param removeoriginalfiles : remove or not those files from disk
  @param action : 0=mode append and replace files, 1=mode update files
  @param relativepath : if !NULL, include only filenames, without their base path */
 void addFilesToArchive( QStringList filestoadd, bool removeoriginalfiles, int action, QString relativepath=NULL);
 /** Create a targ.bz2archive
 @param  nameofarchive: the name of the targz archive
 @param param: list of files to add
 @param relativepath: include only filenames, without their path */
 void createArchive(QString nameofarchive, QStringList filestoadd, QString relativepath=NULL);

 void compressCreatedTarArchive();
 
 protected slots:
    /** The current process ended */
    void endProcess(KProcess*);
};

#endif
