/***************************************************************************
                          FILENAME  -  description                              
                             -------------------                                         
    begin                : DATE                                           
    copyright            : (C) 2006 by Eric Coquelle                         
    email                : EMAIL                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "cwizardsfx.h"
#include "carchiveoperation.h"
#include "cchoixfichier.h"

#include <kapplication.h>
#include <klocale.h>
#include <kstddirs.h>
#include <kfiledialog.h>
#include <kmessagebox.h>
#include <qpixmap.h>
#include <qfont.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qdir.h>


CWizardSfx::CWizardSfx(QWidget *parent, const char *name) : KWizard(parent,name)
{
  setCaption(i18n("KArchiver's wizard"));
  setupPageOne();
  setupPageTwo();
  setupPageThree();
  
  connect(this, SIGNAL(selected(const QString&)), this, SLOT(slotPageChanged(const QString&)));
  connect(bpath, SIGNAL(clicked()), this, SLOT(slotBrowse()));
}

CWizardSfx::~CWizardSfx(){
}

void  CWizardSfx::setupPageOne(){
  
  QWidget* pageone = new QWidget(this);
  QGridLayout* layout=new QGridLayout(pageone, 10, 2, 8);
  titlepageone=i18n("KArchiver self-extracting archive wizard - step 1");

  QLabel* QLabel_1= new QLabel(pageone,"NoName");
  QLabel_1->setPixmap(UserIcon("karchiveur_wizard_large"));
  layout->addMultiCellWidget(QLabel_1, 0, 7, 0, 0);

  QLabel* QLabel_2= new QLabel(pageone,"NoName");
  QLabel_2->setText("<qt><h1>"+i18n("Create a Self-Extracting archive")+"</h1></qt>");
  layout->addWidget(QLabel_2, 0, 1);


  QLabel* QLabel_3= new QLabel(pageone,"NoName");
  QLabel_3->setText("<qt><p>"+
      i18n("A self-extracting archive (sfx) is a standalone executable file, that contains both the compressed files and the extracting software.")
                      +"</p><p>"
      +i18n("KArchiver can create several kind of self-extracting archives:")
                      +"</p></qt>");
  layout->addMultiCellWidget(QLabel_3, 1,7, 1, 1);

  QButtonGroup* QButtonGroup_1= new QButtonGroup(pageone,"NoName");
  QButtonGroup_1->setTitle(i18n("Target platform"));
  layout->addMultiCellWidget(QButtonGroup_1, 8, 10, 1, 1);
  QHBoxLayout* hbox=new QHBoxLayout(QButtonGroup_1, 20, 16);

  radiouniversal= new QRadioButton(QButtonGroup_1,"NoName");
  radiouniversal->setText(i18n("Universal KArchiver's sfx archive"));
  radiouniversal->setChecked(true);
  hbox->addWidget(radiouniversal);

  radio7zwin= new QRadioButton(QButtonGroup_1,"NoName");
  radio7zwin->setText(i18n("Windows 7z sfx archive"));
  hbox->addWidget(radio7zwin);
  
  addPage(pageone, titlepageone);
  setHelpEnabled(pageone, false);
}

void CWizardSfx::setupPageTwo()
{
  pagetwo = new QWidget(this);
  QGridLayout* layout=new QGridLayout(pagetwo, 2, 2, 8);
  titlepagetwo=i18n("KArchiver self-extracting archive wizard - step 2");

  QLabel* labelwizard2i= new QLabel(pagetwo,"NoName");
  labelwizard2i->setPixmap(UserIcon("karchiveur_wizard_large"));
  layout->addMultiCellWidget(labelwizard2i, 0, 2, 0, 0);

  QLabel* QLabel_2= new QLabel(pagetwo,"NoName");
  QLabel_2->setText("<qt><h1>"+i18n("Requirements")+"</h1></qt>");
  layout->addMultiCellWidget(QLabel_2, 0, 0, 1, 2);

  QLabel_3= new QLabel(pagetwo,"NoName");
  QLabel_3->setAlignment(Qt::WordBreak);
  layout->addMultiCellWidget(QLabel_3, 1, 1, 1, 2);

  QLabel_4= new QLabel(pagetwo,"NoName");
  QLabel_4->setAlignment(Qt::WordBreak);
  layout->addMultiCellWidget(QLabel_4, 2, 2, 1, 2);

  addPage(pagetwo, titlepagetwo);
  setHelpEnabled(pagetwo, false);
}

void CWizardSfx::setupPageThree()
{
  QWidget* pagethree = new QWidget(this);
  QGridLayout* layout=new QGridLayout(pagethree, 10, 2, 8);

  QLabel* labelwizard2i= new QLabel(pagethree,"NoName");
  labelwizard2i->setPixmap(UserIcon("karchiveur_wizard_large"));
  layout->addMultiCellWidget(labelwizard2i, 0, 7, 0, 0);

  QLabel* QLabel_2= new QLabel(pagethree,"NoName");
  QLabel_2->setText("<qt><h1>"+i18n("Name of the Sfx archive")+"</h1></qt>");
  layout->addMultiCellWidget(QLabel_2, 0, 0, 1, 2);

  QLabel* QLabel_1= new QLabel(pagethree,"NoName");
  QLabel_1->setText(i18n("Please give a name to your Sfx archive"));
  QLabel_1->setAlignment(Qt::WordBreak);
  layout->addMultiCellWidget(QLabel_1, 2, 2, 1, 2);

  lepathsfx=new QLineEdit(pagethree,"NoName");
  layout->addWidget(lepathsfx, 3, 1);
  
  bpath=new QPushButton(i18n("Browse"), pagethree,"NoName");
  layout->addWidget(bpath, 3, 2);
  
  addPage(pagethree, i18n("KArchiver self-extracting archive wizard - step 3"));
  setHelpEnabled(pagethree, false);
  setFinishEnabled(pagethree, true);
}

/**Check for Page 2 and add a warning message if the Sfx module cannot be found*/
void CWizardSfx::slotPageChanged(const QString& pagetitle)
{
  if(pagetitle==titlepagetwo)
  {
    if(radiouniversal->isChecked())
    {
      QLabel_3->setText(i18n("KArchiver's self-extracting archive work on all platforms provided that the recipients have a java JRE environment installed."));
      if((KGlobal::dirs()->findResource("data", "karchiver/KArchiverSfxModule.jar")).isNull())
      {
        QLabel_4->setText(i18n("Sfx module not found"));
        setNextEnabled(pagetwo, false);
      }
    }
    else if(radio7zwin->isChecked())
    {
      QLabel_3->setText(i18n("7z's self-extracting archive work only Windows. The 7z compressor is only required on this computer"));
      if(!(CArchiveChoice::getInstalledCompressors() & SEVENZ))
      {
        QLabel_4->setText(i18n("The 7z compressor cannot be found on your computer. Please download it from KArchiver's Preferences menu->Plugins"));
        setNextEnabled(pagetwo, false);
      }
      else if((KGlobal::dirs()->findResource("data", "karchiver/SevenzSfxModule.sfx")).isNull())
      {
        QLabel_4->setText(i18n("Sfx module not found"));
        setNextEnabled(pagetwo, false);
      }
    }
  }
  else if(pagetitle==titlepageone)
  {
    setNextEnabled(pagetwo, true);
    QLabel_4->setText("");
  }
}

void CWizardSfx::slotBrowse()
{
  QString newarchivename;

  newarchivename=KFileDialog::getSaveFileName(QDir::homeDirPath(), QString::null, 0L, i18n("Please give a name to your SelfExtracting archive"));
  lepathsfx->setText(newarchivename);
}

int CWizardSfx::getSfxType()
{
  if(radiouniversal->isChecked())
    return CArchiveOperationSfx::UNIVERSAL_SFX;
  return CArchiveOperationSfx::SEVENZ_SFX;
}

QString CWizardSfx::getSfxName()
{
  return lepathsfx->text();
}

void CWizardSfx::accept()
{
  QFileInfo file(getSfxName());
  
  if( (!file.exists() || ( file.exists() && file.isWritable() )) && QFileInfo(file.dirPath(true)).isWritable() )
    QDialog::accept();
  else
    KMessageBox::error(this, i18n("Cannot write to this directory:")+"\n"+file.dirPath(), "KArchiver");
}

#include "cwizardsfx.moc"
