/****************************************************************************
** $Id: dirview.cpp 485403 2005-12-04 05:43:32Z coquelle $
**
** Copyright (C) 1992-1998 Troll Tech AS.  All rights reserved.
**
** This file is part of an example program for Qt.  This example
** program may be used, distributed and modified without limitation.
**
*****************************************************************************/

#include "dirview.h"

#include <string.h>
#include <qdir.h>
#include <qfile.h>
#include <qfileinfo.h>
#include <kiconloader.h>

Directory::Directory( Directory * parent, QString filename, QString image, bool voirfich )
    : QListViewItem( parent ), f(filename ), im(image)
{
  KIconLoader icon;
  m_selected=false;
  p = parent;
  fichiers=voirfich;
	if(strcmp(image,"folder")==0)
		setPixmap(0,icon.loadIcon("folder",KIcon::Small, 16));
	else
		setPixmap(0,icon.loadIcon("folder_open",KIcon::Small, 16));
}


Directory::Directory( QListView * parent )
    : QListViewItem( parent ), f("/")
{
    p = 0;
    readable = TRUE;
		fichiers=FALSE;
}

void Directory::setDisplayFiles(bool fich)
{
	fichiers=fich;
}

void Directory::setOpen( bool o )
{
  if ( o && !childCount() ) {
		QString s( fullName() );
		QDir thisDir( s );
		if ( !thisDir.isReadable() ) {
	    readable = FALSE;
	    return;
		}

	const QFileInfoList * files = thisDir.entryInfoList();
	if ( files ) {
	    QFileInfoListIterator it( *files );
	    QFileInfo * f;
	    KIconLoader icon;

			QString dossier="folder";
			QString dossierOuvert="folder_open";
 	    while( (f=it.current()) != 0 ) {
    		++it;
    		if ( f->fileName() == "." || f->fileName() == ".." )
    		    ; // nothing
    		/*else if ( f->isSymLink() )
    		    new QListViewItem( this, (const char *)f->fileName(),
    				       "Symbolic Link", 0 );*/
    		else if (( f->isDir() )&& f->isReadable())
    			{
			  new Directory( this, f->fileName(), dossier, fichiers);
			  setPixmap(0,icon.loadIcon("folder_open",KIcon::Small, 16));
    			}
    		else if(fichiers)
		  new QListViewItem( this, f->fileName(),
				     f->isFile() ? "File" : "Special", 0 );
   	    }
	}
    }
    QListViewItem::setOpen( o );
}


void Directory::setup()
{
    setExpandable( TRUE );
    QListViewItem::setup();
}


QString Directory::fullName()
{
    QString s;
    if ( p ) {
	s = p->fullName();
	s.append( f.name() );
	s.append( "/" );
    } else {
	s = "/";
    }
    return s;
}


QString Directory::text( int column ) const
{
    if ( column == 0 )
	return f.name();
    else if ( readable )
	return "Directory";
    else
	return "Unreadable Directory";
}


