"""Karrigell script for managing the database books_g_users
Generated 03-06-2005 09:02:08
"""
import os
from HTMLTags import *
import md5

# database-specific modules
import gadfly

def makeDict(res):
    # convert the result of a cursor.fetchall() to a list
    # of dictionaries
    records = []
    for item in res:
        records.append(dict([(fname,item[i]) 
            for (i,fname) in enumerate(['recno', 'login', 'password'])]))
    return records

info = open(r'c:\cygwin\home\QUENTEL\data\books_g.ini').readlines()
admin_login = info[0].strip()
admin_password = info[1].strip()
def authTest():
    return (AUTH_USER==admin_login
        and md5.new(AUTH_PASSWORD).digest()==admin_password)

Authentication(authTest,
    realm=_("Administration"),
    errorMessage=_("Authentication error"))

#parameters
name = "books_g_users"
pageTitle = "books_g users"
field_names = ['login', 'password']
field_types = ['varchar', 'varchar']
try:
    connection = gadfly.gadfly('books_g_users',r'c:\cygwin\home\QUENTEL\data')
    cursor = connection.cursor()
except IOError:
    connection = gadfly.gadfly()
    connection.startup('books_g_users',r'c:\cygwin\home\QUENTEL\data')
    cursor = connection.cursor()
    cursor.execute('CREATE TABLE books_g_users (recno integer, login varchar, password varchar)')

#header
header=HEAD(LINK(rel="stylesheet",href="../default.css") +
    TITLE(pageTitle))

def index():
    user_test = True # default
    print '<html>\n'
    print header
    print H1(pageTitle)

    cursor.execute('SELECT recno,login,password FROM books_g_users')
    records = makeDict(cursor.fetchall())

    if records:
        print '<table class="main" cellpadding="3" cellspacing="0">'
        print '<tr>'
        print Sum([TH(f) for f in field_names])
        if user_test:
            print TH('&nbsp;')*2
        print '</tr>\n'
        counter = 0
        for record in records:
            counter+=1
            if counter % 2:
                print '<tr class="even">'
            else:
                print '<tr class="odd">'
            print TD(record["login"])
            print TD(record["password"])
            if user_test:
                print TD(A('Remove',
                    href="removeRecord?recordId=%s" %record['recno']),
                    Class="main")
                print TD(A('Edit',
                    href="editRecord?recordId=%s" %record['recno']),
                    Class="main")
            print '</tr>'
        print '</table>'
    else:
        print "Empty base"

    if user_test:
        print '<p><a href="editRecord?recordId=-1">New record</a>'
    print '</body>\n</html>'

def editRecord(recordId):
    recordId=int(recordId)
    if recordId>-1:
        cursor.execute('SELECT recno,login,password FROM books_g_users WHERE recno = %s'
               %recordId)
        record = makeDict(cursor.fetchall())[0]

        print header
        print H1("Editing a record")
    else:
        print header
        print H1("New record")
        record=dict([(f,'') for f in ['login', 'password']])
    
    print '<form action="insertRecord">'

    print INPUT(type="hidden",name="recordId",value=recordId)
    print '<table>'
    print TR(TD("login")+TD(INPUT(name="login",size="40",value=record["login"])))
    print TR(TD("password")+TD(INPUT(name="password",size="40",value=record["password"])))
    print '</table>'
    print INPUT(type="submit",value="Ok")
    print '</form>'
    print '</body>\n</html>'

def insertRecord(recordId,**untyped_fields):

    sql="SELECT MAX(recno) FROM books_g_users"
    try:
        cursor.execute(sql)
        res=cursor.fetchall()
        next_id = res[0][0]+1
    except ValueError: # empty base
        next_id = 0

    recordId=int(recordId)
    if recordId==-1:
        sql = 'INSERT INTO books_g_users (recno,login,password) VALUES (%s)' \
            %','.join([str(next_id)]+["'%s'" %untyped_fields[f] for f in ['login', 'password']])
        cursor.execute(sql)
    else:
        vals = ','.join(["%s = '%s'" %(k,v) for (k,v) in untyped_fields.items()])
        sql = 'UPDATE books_g_users SET %s WHERE recno = %s' %(vals,recordId)
        cursor.execute(sql)
    connection.commit()
    
    raise HTTP_REDIRECTION,"index"

def removeRecord(recordId):

    sql = 'DELETE FROM books_g_users WHERE recno = %s' %recordId
    cursor.execute(sql)
    connection.commit()
    raise HTTP_REDIRECTION,"index"

def login():
    print H1("Login")
    print '<form action="check_login" method="post">'
    print TABLE(
        TR(TD("Login")+TD(INPUT(name="login"))) +
        TR(TD("Password")+
            TD(INPUT(name="password", Type="password"))) +
        TR(TD(INPUT(Type="submit",value="Ok"))+
            TD("&nbsp;"))
        )
    print '</form>'

def check_login(**user_data):

    if users_cursor is not None:
        sql = "SELECT recno,login,password FROM books_g_users_users"
        sql += " WHERE login = '%s' AND password = '%s'" \
            %(user_data['login'],user_data['password'])
        users_cursor.execute(sql)
        user_record = users_cursor.fetchall()
        if user_record:
            user_record = dict(zip(['recno','login','password'],user_record[0]))
    else:
        user_record = None

    if not user_record:
        print "Unknown user"
        print P(A("Back",href="index"))
    else:
        setattr(Session(),'%s_user' %name, user_record['recno'])
        raise HTTP_REDIRECTION,'index'

def logout():
    Session().close()
    raise HTTP_REDIRECTION,'index'
    
def error(msg):
    print header
    print H1(pageTitle)
    print msg
    print P(A('Back',href='index'))
