import re
import datetime

def field_names(fields):
    return [ f.split(":")[0] for f in fields ]

def field_types(fields):
    return [ f.split(":")[1] for f in fields ]

#----------------------------------------------------------------------
# _strToBool
#----------------------------------------------------------------------
def _strToBool(boolString):
    if boolString == 'True': return True
    elif boolString == 'False': return False
    else: raise KBError('Invalid value for boolean: %s' % boolString)


#----------------------------------------------------------------------
# _strToDate
#----------------------------------------------------------------------
def _strToDate(dateString):
    # Split the date string up into pieces and create a
    # date object.
    return datetime.date(*map(int, dateString.split('-'))) 

#----------------------------------------------------------------------
# _strToDateTime
#----------------------------------------------------------------------
def _strToDateTime(dateTimeString):
    # Split datetime string into datetime portion microseconds portion.
    tempDateTime = dateTimeString.split('.')
    # Were there microseconds in the datetime string.
    if len(tempDateTime) > 1: microsec = int(tempDateTime[1])
    else: microsec = 0

    # Now, split the datetime portion into a date
    # and a time string.  Take all of the pieces and
    # create a datetime object.
    tempDate, tempTime = tempDateTime[0].split(' ')
    y, m, d = tempDate.split('-')
    h, min, sec = tempTime.split(':')
    return datetime.datetime(int(y),int(m),int(d),int(h),int(min),
     int(sec),microsec)

# Regular expression used to determine if field needs to be
# encoded.
encodeRegExp = re.compile(r'\n|\r|\032|\|')

# Regular expression used to determine if field needs to be
# un-encoded.
unencodeRegExp = re.compile(
 r'&linefeed;|&carriage_return;|&substitute;|&pipe;')


#----------------------------------------------------------------------
# _encodeString
#----------------------------------------------------------------------
def _encodeString(s):
    '''Encode a string.

    Translates problem characters like \n, \r, and \032 to benign
    character strings.

    Keyword Arguments:
        s - string to encode.

    Returns encoded string.
    '''
    if encodeRegExp.search(s):
        s = s.replace('\n', '&linefeed;')
        s = s.replace('\r', '&carriage_return;')
        s = s.replace('\032', '&substitute;')
        s = s.replace('|', '&pipe;')
    return s

# This will be used to validate and convert the field types in
# the header rec of the table into valid python types.
strToTypes = {'int':int, 'Integer':int, 'float':float, 
 'Float':float, 'datetime.date':datetime.date, 
 'Date':datetime.date, 'datetime.datetime':datetime.datetime,
 'DateTime':datetime.datetime, 'bool':bool, 'Boolean':bool,
 'str':str, 'String':str}
        
def conv(value_as_string,typ):
    return strToTypes[typ](value_as_string)

def conv_rec(field_names, field_types,**string_fields):
    typed_fields = {}
    for (n,t) in zip(field_names,field_types):
        typed_fields[n] = conv(string_fields[n],t)
    return typed_fields