"""
File: index.ks
Author: AN
Date: Jan 2006
Description:

ToDo:
 * Comments
"""
from Cheetah.Template import Template
from blogdb import BlogDB


def _auth():
    """Return a session object if we're logged on."""
    session = Session()
    if hasattr(session, 'username') and session.username:
        return session.username
    else:
        return None
        
def _error(message):
    showPage('error', {'message': message})

def _message(message):
    showPage('message', {'message': message})

def _escape(text):
    """Turn comment text into simple text"""
    return text.replace('&', '&amp;') \
               .replace('<', '&lt;') \
               .replace('>', '&gt;') \
               .replace('\n', '<br />')

def index(recno=None):
    """Main page"""
    body = 'Main'
    rightmenu = 'Menu'
    db = BlogDB()

    if not recno:
        entries = db.getlastposts(10)
        # Only show comments on individual entries
        comments = []
        showcomments = False
    else:
        entries = db.getentry(recno)
        comments = db.getcomments(recno)
        showcomments = True

    showPage('posts', locals())

def showPage(page, vars={}):
    """Actual page showing"""
    vars['pagename'] = page + '.tmpl'
    vars['username'] = _auth()
    vars['message'] = vars.get('message', None)
    print Template(file='index.tmpl', searchList=[vars])

def login(username, password, login):
    """Log in as username with the given password
    (login comes from the submit button)"""
    if username == 'Andy' and password == 'password':
        session = Session()
        session.username = username
        session.password = password
        index()
    else:
        _error('Wrong username and password!')

def logout():
    """Forget the session, logout"""
    session = Session()
    session.username = None
    session.close()
    index()

def newentry():
    """Add a new entry"""
    showPage('editpost',
        {'recno': 'new', 'body': '', 'subject': 'Subject'})
    
def editentry(recno):
    """Edit an existing id"""
    entry = BlogDB().getentry(recno)
    if not entry:
        _error('No entry with id "%s"' % recno)
        return
    showPage('editpost', entry[0])

def saveentry(recno=None, subject=None, bodytext=None, addpost=None):
    """Save post, existing or new"""
    db = BlogDB()
    username = _auth()
    if not username:
        _error('You must be logged in to post!')
        return
    entry = db.getentry(recno)
    if entry and entry[0]['username'] != username:
        _error('You can only edit your own entries!')
        return
    db.saveentry(username, recno, subject, bodytext)
    index()

def archive():
    entries = BlogDB().getheaders()
    showPage('archive', {'entries': entries})

def deleteentry(recno):
    """Delete the entry <recno>"""
    username = _auth()
    if not username:
        _error('You must be logged in to delete entries!')
        return
    db = BlogDB()
    entry = db.getentry(recno)
    if not entry:
        _error('No entry with id "%s"' % recno)
        return
    if entry[0].get('username') != username:
        _error('You can only delete your own entries!')
        return          
    db.deleteentry(recno)
    _message('Deleted the entry "%s"' % entry[0]['subject'])

def addcomment(entryid, name, comment):
    db = BlogDB()
    entry = db.getentry(entryid)
    if not entry:
        _error('Trying to comment on a non-existant entry!')
    db.addcomment(entryid, _escape(name), _escape(comment))
        
    _message('%s added comment to entry %s:<br /><br />%s' % (name, entryid, comment))
    
def deletecomment(recno):
    # @@ Logged in too.
    if not recno.isdigit():
        _error('Invalid comment id!')
    db = BlogDB()
    db.deletecomment(int(recno))
    _message('Deleted comment %s' % recno)