import sys,os, random
import kirbybase

def createBase():
    db = kirbybase.KirbyBase()

    for path in ('chansons.tbl','recueils.tbl','dialectes.tbl',
        'genres.tbl','chansons_par_dialectes.tbl',
        'chansons_par_recueils.tbl'):
        try:
            os.remove(path)
        except OSError:
            pass

    db.create('chansons.tbl',
        ['url:str','breton:str','francais:str','prix:float','id_genre:int'])
    db.create('recueils.tbl',['nom:str'])
    db.create('dialectes.tbl',['nom:str'])
    db.create('genres.tbl',['nom:str'])
    db.create('chansons_par_dialectes.tbl',['id_chanson:int','id_dialecte:int'])
    db.create('chansons_par_recueils.tbl',['id_chanson:int','id_recueil:int'])

    chansons=open("base.txt").readlines()

    l_chansons=[]
    id_chanson = 0
    l_recueils=[]
    l_dialectes=[]
    l_genres=[]
    chansonsParRecueil=[]
    chansonsParGenre=[]
    chansonsParDialecte=[]

    for line in chansons:
        [url,breton,francais,recueils,genre,dialectes,enreg]=line.strip().split("#")
        if not [genre] in l_genres:
            l_genres.append([genre])
        id_genre = 1 + l_genres.index([genre])
        prix=float(random.randrange(200,400))/100
        l_chansons.append([url,breton,francais,prix,id_genre])
        id_chanson += 1

        recs=recueils.split(";")
        for rec in recs:
            if not [rec] in l_recueils:
                l_recueils.append([rec])
            id_recueil = 1+l_recueils.index([rec])
            chansonsParRecueil.append([id_chanson,id_recueil])
        dials=dialectes.split(";")
        for dial in dials:
            if not [dial] in l_dialectes:
                l_dialectes.append([dial])
            id_dialecte = 1 + l_dialectes.index([dial])
            chansonsParDialecte.append([id_chanson, id_dialecte])


    db.insertBatch('chansons.tbl',l_chansons)
    db.insertBatch('recueils.tbl',l_recueils)
    db.insertBatch('dialectes.tbl',l_dialectes)
    db.insertBatch('genres.tbl',l_genres)
    db.insertBatch('chansons_par_dialectes.tbl',chansonsParDialecte)
    db.insertBatch('chansons_par_recueils.tbl',chansonsParRecueil)

    db.close()

if not os.path.exists('chansons.tbl'):
    createBase()

