"""Karrigell script for managing the database books
Generated 08-02-2006 10:12:27
"""
import os
from HTMLTags import *
import md5

# database-specific modules
import kirbybase
import kb_utils

#parameters
name = "books"
pageTitle = "Managing base books"
field_names = ['title', 'year', 'author']
field_types = ['str', 'date', 'str']
users = r'c:\\karrigell\\data\\students'
admin_file = r"c:\karrigell\data\books.ini"
table = r'c:\\karrigell\\data\\books'
# create an instance of kirbybase
db=kirbybase.KirbyBase()

# create the database if it doesn't already exist
if not os.path.exists(table):
    db.create(table,['title:str', 'year:datetime.date', 'author:str'])

#header
header=HEAD(LINK(rel="stylesheet",href="../default.css") +
    TITLE(pageTitle))

def index():
    user_test = False # default
    print '<html>\n'
    print header
    print H1(pageTitle)

    user_id = None
    so = Session()
    if hasattr(so,'%s_user' %name):
        user_id = getattr(so,'%s_user' %name)
        user = db.select(users,['recno'],[user_id],returnType='dict')[0]
        print user['login']
        print BR(A("Logout",href="logout"))
        user_test = True
    else:
        print A("Login",href="login")
    print P()
    # select all the items and return a list of dictionaries, one
    # for each record, indexed by the field names
    records=db.select(table,['recno'],['*'],returnType='dict')

    if records:
        print '<table class="main" cellpadding="3" cellspacing="0">'
        print '<tr>'
        print Sum([TH(f,Class="main") for f in field_names])
        if user_test:
            print TH('&nbsp;',Class="main")*2
        print '</tr>\n'
        counter = 0
        for record in records:
            counter+=1
            if counter % 2:
                print '<tr class="even">'
            else:
                print '<tr class="odd">'
            print TD(record["title"],Class="main")
            print TD(record["year"],Class="main")
            print TD(record["author"],Class="main")
            if user_test:
                print TD(A('Remove',
                    href="removeRecord?recordId=%s" %record['recno']),
                    Class="main")
                print TD(A('Edit',
                    href="editRecord?recordId=%s" %record['recno']),
                    Class="main")
            print '</tr>'
        print '</table>'
    else:
        print "Empty base"

    if user_test:
        print '<p><a href="editRecord?recordId=-1">New record</a>'
    print '<p><a href="../students.ks">Admin</a>'

    print '</body>\n</html>'

def editRecord(recordId):
    recordId=int(recordId)
    print header
    print '<body>'
    print SCRIPT(Type='text/JavaScript',src='../scw.js')
    print '<script>scwDateOutputFormat  = "YYYY-MM-DD"'
    print 'scwDateInputSequence = "YMD"'
    print '</script>'

    if recordId>-1:
        record=db.select(table,["recno"],[recordId],returnType='dict')[0]
        print H1("Editing a record")
    else:
        print H1("New record")
        record=dict([(f,'') for f in ['title', 'year', 'author']])
    
    print '<form action="insertRecord" method="post">'

    print INPUT(type="hidden",name="recordId",value=recordId)
    print '<table>'
    print TR(TD("title")+TD(TEXTAREA(record["title"],name="title",rows="10",cols="50")))
    print TR(TD("year")+TD(INPUT(name="year",id="year",size="20",value=record["year"])+A(IMG(src="../Calandar.gif",border=0),href= "javascript:scwShow(document.getElementById('year'), this);")))
    print TR(TD("author")+TD(INPUT(name="author",size="40",value=record["author"])))
    print '</table>'
    print INPUT(type="submit",value="Ok")
    print '</form>'
    print '</body>\n</html>'

def insertRecord(recordId,**untyped_fields):
    try:
        typed_fields = kb_utils.conv_rec(field_names,field_types,**untyped_fields)
    except ValueError,msg:
        error(msg)
        raise SCRIPT_END
    recordId=int(recordId)
    if recordId==-1:
        db.insert(table,typed_fields)
    else:
        db.update(table,["recno"],[recordId],typed_fields)
    db.pack(table)
    raise HTTP_REDIRECTION,"index"

def removeRecord(recordId):
    db.delete(table,["recno"],[int(recordId)])
    db.pack(table)
    raise HTTP_REDIRECTION,"index"

def login():
    print H1("Login")
    print '<form action="check_login" method="post">'
    print TABLE(
        TR(TD("Login")+TD(INPUT(name="login"))) +
        TR(TD("Password")+
            TD(INPUT(name="password", Type="password"))) +
        TR(TD(INPUT(Type="submit",value="Ok"))+
            TD("&nbsp;"))
        )
    print '</form>'

def check_login(**user_data):
    try:
        user_record = db.select(users,['login','password'],
            [user_data['login'],user_data['password']],
            returnType = 'dict')[0]
    except IndexError:
        print "Unknown user"
        print P(A("Back",href="index"))
        return
    except kirbybase.KBError,msg:
        print "An error occured when checking login info"
        print P(msg)
        print P(A("Back",href="index"))
        return
    if not user_record:
        print "Unknown user"
        print P(A("Back",href="index"))
    else:
        setattr(Session(),'%s_user' %name, user_record['recno'])
        raise HTTP_REDIRECTION,'index'

def logout():
    Session().close()
    raise HTTP_REDIRECTION,'index'
    
def error(msg):
    print header
    print H1(pageTitle)
    print msg
    print P(A('Back',href='index'))

def admin():
    raise HTTP_REDIRECTION, '../students.ks/index'
