/***************************************************************************
 *   Copyright (C) 2005 by Roberto Cappuccio and the Kat team              *
 *   Roberto Cappuccio : roberto.cappuccio@gmail.com                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/

#ifndef _DLGSTARTUPWIZARD_H_
#define _DLGSTARTUPWIZARD_H_

#include <qpixmap.h>
#include <kwizard.h>
#include <qstring.h>
#include <qvaluevector.h>

class QVBoxLayout;
class QHBoxLayout;
class QGridLayout;
class QSpacerItem;
class QWidget;
class QLabel;
class QListView;
class QListViewItem;
class QPushButton;
class QFont;

class FancyListViewItem : public QListViewItem
{
public:
    FancyListViewItem( QListView* parent )
        : QListViewItem( parent )
    {}

    FancyListViewItem( QListViewItem* parent )
        : QListViewItem( parent )
    {}

    void paintCell( QPainter* painter, const QColorGroup& cg,
                    int column, int width, int align );

    QColor foreground( uint ) const;
    void setForeground( uint, const QColor& );

    bool bold( uint ) const;
    void setBold( uint, const bool );

private:
    QValueVector<QColor> foregrounds;
    QValueVector<bool> bolds;
};


class DlgStartupWizard : public KWizard
{
    Q_OBJECT

public:
    DlgStartupWizard( QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
    ~DlgStartupWizard();


protected:
    void searchProgram( const QString&, FancyListViewItem* );
    bool testKatdRunning();
    void initWizard();
    void addItem( const QString&, const QString&, const QString& );

private:
    QWidget* Welcome;
    QLabel* plPicture0;
    QLabel* tlWelcome;
    QWidget* Page1;
    QLabel* plPicture1;
    QLabel* tlInotify;
    QLabel* tlInotifyResults;
    QWidget* Page2;
    QLabel* plPicture2;
    QLabel* tlDaemon;
    QLabel* tlDaemonResults;
    QPushButton* pbStart;
    QWidget* Page3;
    QLabel* plPicture3;
    QLabel* tlHelpers;
    QListView* listView1;
    QPushButton* pbRecheck;
    QWidget* Page4;
    QLabel* plPicture4;
    QLabel* tlCatalog;

protected slots:
    void slotRecheckHelpers();
    bool slotStartDaemon();
    bool slotRestartDaemon();
};

#endif // _DLGSTARTUPWIZARD_H_
