/***************************************************************************
 *   Copyright (C) 2005 by Roberto Cappuccio and the Kat team              *
 *   Roberto Cappuccio : roberto.cappuccio@gmail.com                       *
 *   Praveen Kandikuppa : praveen9@gmail.com                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/

#include <kdebug.h>

#include "kattemptable.h"

KatTempTable::KatTempTable ( CppSQLite3DB* db, int catalogId )
    : m_db (db), m_catalogId( catalogId ), m_totalRecords (0), m_readRecords (0)
{
}

KatTempTable::~KatTempTable ()
{
}

void KatTempTable::clearTable()
{
    try
    {
        m_db->execDML( "delete from indexerstore where catalogid=" + QString::number ( m_catalogId ) + ";" );
    }
    catch ( CppSQLite3Exception& e )
    {
        kdDebug() << k_funcinfo << " " << e.errorMessage() << endl;
    }
    m_totalRecords = 0;
}

void KatTempTable::addRecords ( const QMap<QString, int>& records)
{
    CppSQLite3Statement stmt;

    openTransaction();
    QMap<QString, int>::ConstIterator end( records.end() );
    for (QMap<QString, int>::ConstIterator it = records.begin(); it != end; ++it)
    {
        try
        {
            stmt = m_db->compileStatement( "insert into indexerstore (catalogid,key,data) values(?,?,?);" );
            stmt.bind( 1, m_catalogId );
            stmt.bind( 2, it.key() );
            stmt.bind( 3, it.data() );

            stmt.execDML();
            stmt.finalize();

            m_totalRecords ++;
        }
        catch ( CppSQLite3Exception& e )
        {
            kdDebug() << k_funcinfo << e.errorMessage() << endl;
        }
    }
    commitTransaction();
}

QMap<QString, int> KatTempTable::readRecords ( int limit)
{
    QMap<QString, int> records;
    QString DML = "select * from indexerstore where catalogid=" +
                  QString::number ( m_catalogId ) +
                  " limit " + QString::number (limit) +
                  " offset " + QString::number( m_readRecords ) + ";";

    try
    {
        CppSQLite3Query q = m_db->execQuery( DML );

        while ( !q.eof() )
        {
            records[ q.getStringField( "key" ) ] = q.getIntField( "data" );
            m_readRecords ++;
            q.nextRow();
        }

        q.finalize();
    }
    catch ( CppSQLite3Exception& e )
    {
        kdDebug() << k_funcinfo << " " << e.errorMessage() << endl;
    }

    return records;
}

KatTempTable* KatTempTable::tempTable( CppSQLite3DB* db, int catalogId )
{
    return new KatTempTable ( db, catalogId );
}

int KatTempTable::openTransaction()
{
    try
    {
        m_db->execDML( "begin transaction;" );
    }
    catch ( CppSQLite3Exception& e )
    {
        kdDebug() << k_funcinfo << " " << e.errorMessage() << endl;
        return e.errorCode();
    }
    return 0;
}

int KatTempTable::commitTransaction()
{
    try
    {
        m_db->execDML( "commit transaction;" );
    }
    catch ( CppSQLite3Exception& e )
    {
        kdDebug() << k_funcinfo << " " << e.errorMessage() << endl;
        return e.errorCode();
    }
    return 0;
}

