/***************************************************************************
 *   Copyright (C) 2004 by Stefano Salvador                                *
 *   stefano@diamante                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef KATALOGSERVICEDLG_H
#define KATALOGSERVICEDLG_H

#include "katalogservicedlgbase.h"

#include <dcopobject.h>

class Katalog;
class KURL;
class DCOPClient;

class KatalogServiceDlg : public KDialogServiceDlgBase, public DCOPObject
{
  Q_OBJECT
  K_DCOP

k_dcop:
  void finished(QString);

public:
  KatalogServiceDlg(QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
  ~KatalogServiceDlg();
  
  void setURL(KURL* url);
  void setClient(DCOPClient *c){client = c;}
  void setAppID(QCString s){appId = s;}

private:
  Katalog *m_katalog;
  KURL *m_url;
  KURL *m_url_save;
  QCString appId;
  DCOPClient *client;

protected:
  /*$PROTECTED_FUNCTIONS$*/
  bool initKatalog( const KURL & url );
  void wakeDCOP();

protected slots:
  /*$PROTECTED_SLOTS$*/
  virtual void reject();
  virtual void accept();

private slots:
    void slotClose();

};

#endif

