/*
 * encodings.hh
 * This file is part of katoob
 *
 * Copyright (C) 2006 Mohammed Sameer
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __ENCODINGS_HH__
#define __ENCODINGS_HH__

#include <vector>
#include <string>
#include <glibmm/ustring.h>
#include <glibmm/convert.h>

struct Encoding {
  std::string name;
  std::string encoding;
};

struct Language {
  std::string name;
  std::vector<Encoding *> children;
};

class Encodings {
public:
  Encodings();
  ~Encodings();
  int languages() { return _languages.size(); }
  int languages(int x) { return _languages[x]->children.size(); }
  std::string& language(int x) { return _languages[x]->name; }
  std::string& name(unsigned x, unsigned y) { return _languages[x]->children[y]->name; }

  int get(std::string&);
  const std::string& get(unsigned int);
  const std::string& name(unsigned int);
  int default_save() { return _default_save; }
  int default_open() { return _default_open; }
  int size() { return _encodings.size(); }
  //  const std::string& at(unsigned int x);
  const std::string& at(unsigned int x) { return _encodings.at(x)->name; }
  bool utf8(std::string&);
  int utf8() { return 28; }
  bool convert(std::string&, std::string&, unsigned int, unsigned int, std::string&);
  int convert(std::string&, std::string&, int);
private:
  std::vector<Encoding *> _encodings;
  std::vector<Language *> _languages;
  int _default_save;
  int _default_open;
protected:
  friend class Conf;
  void default_save(unsigned int x) { if (x <= _encodings.size()) { _default_save = x; } }
  void default_open(unsigned int x) { if (x <= _encodings.size()) { _default_open = x; } }
};

#endif /* __ENCODINGS_HH__ */
