/*
 * mdi.hh
 * This file is part of katoob
 *
 * Copyright (C) 2006 Mohammed Sameer
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __MDI_HH__
#define __MDI_HH__

#include <vector>
#include <gtkmm/notebook.h>
#include "replacedialog.hh"
#include "document.hh"
#include "encodings.hh"
#include "dispatcher.hh"
#include "import.hh"
#include "export.hh"

#define TABS_POS_TOP                    101
#define TABS_POS_BOTTOM                 102
#define TABS_POS_RIGHT                  103
#define TABS_POS_LEFT                   104

class MDI : public Gtk::Notebook {
public:
  MDI(Conf&, Encodings&);
  ~MDI();
  void document(std::string&, int = -1);
  void document();

  Document *active();

  bool close_all();

  bool close(int n=-1);

  /* Signal callbacks. */
  void create_cb() { document(); }
  void open_cb();
  void open_location_cb();
  void save_cb();
  void save_as_cb();
  void save_copy_cb();
  void revert_cb();
#ifdef ENABLE_PRINT
  void print_cb();
#endif
  void close_cb();

  void recent_cb(std::string&);

  void undo_cb();
  void redo_cb();
  void cut_cb();
  void copy_cb();
  void paste_cb();
  void erase_cb();
  void select_all_cb();
  void insert_file_cb();

  void wrap_text(bool);
  void line_numbers(bool);

  void save_all_cb();
  void close_all_cb();

#ifdef HAVE_SPELL
  void auto_spell(bool);
  void spell();
  bool set_dictionary(std::string&, std::string&);
#endif

  void goto_line_cb();
  void goto_line_cb2(int);
  void find(std::string&);
  void find_cb();
  void find_next_cb();
  void replace_cb();

  void execute_cb();

  void on_switch_page_cb(GtkNotebookPage*, guint);

  bool set_encoding(int, int&);

  void activate(int);

  void import_cb(Import im);
  void export_cb(Export ex);

  /* Our signals. */
  sigc::signal<void> recent_regenerate;
  sigc::signal<void, int> signal_reset_gui;

  // Signals we get from the Document class.
  sigc::signal<void, int, bool> signal_document_modified;
  sigc::signal<void, bool> signal_document_can_undo;
  sigc::signal<void, bool> signal_document_can_redo;
  sigc::signal<void, int, bool> signal_document_readonly;
  sigc::signal<void, std::string&> signal_document_file_changed;
  sigc::signal<void, int, int> signal_document_cursor_moved;
  sigc::signal<void, int> signal_document_encoding_changed;
  sigc::signal<void, bool> signal_document_overwrite_toggled;
  sigc::signal<void, std::string, int> signal_document_title_changed;
  sigc::signal<void, bool> signal_document_wrap_text;
  sigc::signal<void, bool> signal_document_line_numbers;
#ifdef HAVE_SPELL
  sigc::signal<void, std::string> signal_document_dictionary_changed;
#endif
#ifdef ENABLE_HIGHLIGHT
  sigc::signal<void, int> signal_document_highlight;
#endif
  sigc::signal<void, int> signal_doc_activated;
  sigc::signal<void, bool, bool, std::string> signal_document_added;
  sigc::signal<void, int> signal_document_removed;

#ifdef HAVE_SPELL
  sigc::signal<void, bool> signal_document_spell_enabled;
#endif

  sigc::signal<void> signal_closed_document_erased;
  sigc::signal<void, std::string>signal_closed_document_added;
  void closed_document_activated_cb(int);

  void reset_gui();

  void signal_extra_button_clicked_cb(std::string);

#ifdef ENABLE_HIGHLIGHT
  void highlighter_clicked_cb(int);
#endif

private:
  void connect_signals(Document *);
  bool replace_dialog_signal_find_cb(ReplaceDialog *);
  void replace_dialog_signal_replace_cb(ReplaceDialog *);
  void replace_dialog_signal_replace_all_cb(ReplaceDialog *);

  // Signal handlers.
  void signal_document_modified_cb(bool);
  void signal_document_can_undo_cb(bool b) { signal_document_can_undo.emit(b); }
  void signal_document_can_redo_cb(bool b) { signal_document_can_redo.emit(b); }
  void signal_document_readonly_cb(bool);
  void signal_document_file_changed_cb(std::string s) { signal_document_file_changed.emit(s); }
  void signal_document_cursor_moved_cb(int c, int l) { signal_document_cursor_moved.emit(c, l); }
  void signal_document_encoding_changed_cb(int e) { signal_document_encoding_changed.emit(e); }
  void signal_document_overwrite_toggled_cb(bool b) { signal_document_overwrite_toggled.emit(b); }
  void signal_document_title_changed_cb(std::string);

#ifdef ENABLE_HIGHLIGHT
  void signal_document_highlight_cb(int x) { signal_document_highlight.emit(x); }
#endif
#ifdef HAVE_SPELL
  void signal_document_spell_enabled_cb(bool s) { signal_document_spell_enabled.emit(s); }
  void signal_dictionary_changed_cb(std::string d) { signal_document_dictionary_changed.emit(d); }
#endif
  void signal_document_wrap_text_cb(bool w) { signal_document_wrap_text.emit(w); }
  void signal_document_line_numbers_cb(bool ln) { signal_document_line_numbers.emit(ln); }

  void signal_document_label_close_clicked_cb(Document *);

  void signal_document_dict_lookup_cb(std::string);

  void add(Document *, bool signals = true);
  bool save();
  bool save(bool);
  bool save(Document *);

  std::vector<Document *> children;
  std::vector<Document *> closed_children;

  Conf& _conf;
  Encodings& _encodings;
};

#endif /* __MDI_HH__ */
