#ifndef _CLOSURE_H // -*-C++-*-
#define _CLOSURE_H

/**
    Kaya run-time system
    Copyright (C) 2004, 2005 Edwin Brady

    This file is distributed under the terms of the GNU Lesser General
    Public Licence. See COPYING for licence.
*/

#include <pthread.h>
#define GC_PTHREADS
#include <gc/gc_cpp.h>
#include "VMState.h"
#include "Heap.h"

class Closure : public gc_cleanup {
public:
    // Create a closure from a function, which will have <args> as its locals.
    Closure(VMState* vm, func fn,int args, bool stack=true);
    ~Closure();

    // Run the closure. Pushes m_args onto the stack, then runs the function
    // as normal.
    void run(VMState* vm);

    func getfn() { return m_fn; }
    int getFnID() { return ::getFnID(m_fn); }
    int getNumArgs() { return m_numargs; }
    Value** getArgs() { return m_args; }

    void setArg(int i,Value* v) { m_args[i]=v; }

    bool eq(Closure* c);
    Closure* copy();

private:
    func m_fn;
    Value** m_args;
    int m_numargs;
};

#endif
