#ifndef _HEAP_H // -*-C++-*-
#define _HEAP_H

/**
    Kaya run-time system
    Copyright (C) 2004, 2005 Edwin Brady

    This file is distributed under the terms of the GNU Lesser General
    Public Licence. See COPYING for licence.
*/

using namespace std;

#include <pthread.h>
#define GC_PTHREADS
#include <gc/gc_cpp.h>

#include <gc/new_gc_alloc.h>
#include <vector>
#include "ValueFuns.h"

class VMState;

typedef void(*func)(VMState*);

class Value;
class String;
class Array;
class Exception;
class Union;
class Closure;

// I really shouldn't call this Real! Float/Double better.
class Real : public gc
{
public:
    Real(double n):number(n) {}
    double number;
};

class Value;

class Union : public gc_cleanup
{
public:
    // If getargs is true, get arguments from the stack in vm.
    Union(VMState* vm, int tag,int arity, bool getargs = true);
    ~Union() { GC_FREE(args); }

    bool eq(Union* x);
    int cmp(Union* x);
    Union* copy();

    int tag;
    int arity;
    Value** args;
};

class Value : public gc
{
public:
    /// Create an initialised value.
    Value(void* ptr, FunTable* ft);

    valtype getType() { return m_funtable->getType(); }

    /// Get an integer out. Assumes you've checked/know.
    int getInt() { return (int)m_val; };
    /// Get a real number out
    double getReal() { return ((Real*)m_val)->number; }

    /// Get the function pointer. Assumes you've checked/know.
    Closure* getFunc() { return (Closure*)m_val; }

    /// Get the string
    String* getString();
    /// Get the array.
    Array* getArray();
    /// Get the union.
    Union* getUnion();
    /// Get the exception.
    Exception* getExcept();

    /// Run the closure stored here.
    void runClosure(VMState *vm);

    /// Coercions
    void int2str();
    void str2int();
    void str2real();
    void chr2str();
    void bool2str();
    void str2chr();
    void int2real();
    void real2int();
    void real2str();

    /// Get the tag out of a union
    int getTag() { return ((Union*)m_val)->tag; }


    /// Get the raw pointer out.
    void* getRaw() { return m_val; }


    /// Update to be an integer.
    void setInt(int i);

    /// Update to be a real
    void setReal(double i);

    /// Update to be a function.
    void setFunc(Closure* f);

    /// Update to be a string.
    void setString(String* s);

    /// Update to be ana rray.
    void setArray(Array* a);

    void readString();
    void readInt();

    /// Set a raw pointer.
    void setPtr(Value* p) {
//    cout << "Making " << this << " to " << p->m_val << endl;
	m_val=p->m_val;
	m_funtable=p->m_funtable;
    }

    void addVal(Value* v) {
	m_val=(void*)((int)m_val+(int)(v->m_val));
    }

    void subVal(Value* v) {
	m_val=(void*)((int)m_val-(int)(v->m_val));
    }

    void mulVal(Value* v) {
	m_val=(void*)((int)m_val*(int)(v->m_val));
    }

    void divVal(Value* v) {
	m_val=(void*)((int)m_val/(int)(v->m_val));
    }

    /// Set an array element.
//    void setIdxPtr(Value* p,unsigned i);

    /// Set a value from the projection of the top stack item
    void project(VMState* vm, int i);
    /// Project an argument out directly.
//    void projarg(int i, int t);

    /// Initialise an array with dimensions taken from the stack.
//    void makeArray(int i,vector<Value*>& stack);

    /// Lookup a value in an array --- resize/create if necessary.
    Value* lookup(VMState* vm, int i);
    /// Get the length of an array
    int length();

    /// Get the function table out
    FunTable* getFunTable() { return m_funtable; }
    
private:
    void* m_val;
    FunTable* m_funtable;
};

class String : public gc_cleanup
{
public:
    String(char* val);
    String(char val);

    char* getVal();

    int length();
    char getIndex(int i);
    void setIndex(int i,char c);
    void append(String* s);
    bool eq(String* s);
    int cmp(String* s);
    int hash();

private:
    char* m_str;
    int m_alloc;
};

class Exception : public gc
{
public:
    Exception(VMState* vm);
    void show();
    bool eq(Exception* x);
    int cmp(Exception* x);
    
    String* err;
    int code;
};

#endif
