/**
    Kaya run-time system
    Copyright (C) 2004, 2005 Edwin Brady

    This file is distributed under the terms of the GNU Lesser General
    Public Licence. See COPYING for licence.
*/

#include <pthread.h>
#define GC_PTHREADS
#include <gc/gc_cpp.h>
#include <setjmp.h>

#include <gc/new_gc_alloc.h>
#include <assert.h>
#include <stack>
#include <iostream>
#include <map>

using namespace std;

#include "VM.h"
#include "VMState.h"


// Vect valstack;

/*Value** valstack;
map<char*,Value**> globs;
map<int,func> funmap;

int stacksize;
int stackalloc;
int globalloc;

stack<jmp_buf*> except_stack;
stack<int> stack_stack; // Stack state when an exception happens.
*/

//VMState* vm;

VMState* initstack()
{
    return new VMState();
/*    stacksize=0;
    stackalloc=100;
    globalloc=100;
    valstack = (Value**)GC_MALLOC_UNCOLLECTABLE(sizeof(Value*)*stackalloc);*/
}

void finish(VMState* vm)
{
    vm->finish();
/*    if (stacksize!=0) {
	cerr << "Warning: Stack size is non-zero (" << stacksize << ")" << endl;
	}*/
}

// Value* doPop()
// {
//     --stacksize;
//     Value* tmp=valstack[stacksize];
//     valstack[stacksize]=NULL;
//     return tmp;
// }

// void addToFunMap(int id, func fn)
// {
//     funmap[id]=fn;
// }

// func getFn(int id)
// {
//     return funmap[id];
// }

// int getFnID(func fn)
// {
//     map<int,func>::iterator it = funmap.begin();
//     for (;it!=funmap.end();it++) {
// 	if ((*it).second == fn) { return ((*it).first); }
//     }
//     return -1;
// }

// void push(Value* val)
// {
//     // FIXME: Grow stack if necessary? Might be quite an overhead... maybe 
//     // make it an option.
//     valstack[stacksize] = val;
//     ++stacksize;
// }

// int tag()
// {
// //    cout << "Tag is " << valstack[stacksize-1]->getTag() << endl;
//     return valstack[stacksize-1]->getTag();
// }

// // Value* doPop()
// // {
// //     Value* tmp = valstack.back();
// //     valstack.pop_back();
// //     return tmp;
// // }

// void readInt()
// {
//     Value* v=new Value(NULL,inttable);
//     v->readInt();
//     push(v);
// }

// void readStr()
// {
//     Value* v=new Value(NULL,stringtable);
//     v->readString();
//     push(v);
// }

// void doAppend()
// {
//     Value* str2=doPop();
//     Value* str1=doPop();
//     String* str=new String(str1->getString()->getVal());
//     str->append(str2->getString());
//     push(new Value((void*)str,stringtable));
// }

// void doEqExcept(bool inv)
// {
//     Value* e2=doPop();
//     Value* e1=doPop();
//     bool eq = (e2->getExcept()->eq(e1->getExcept()));
//     if (inv) { eq = !eq; }
//     if (eq) {  push(new Value((void*)1,inttable)); }
//     else {  push(new Value((void*)0,inttable)); }
// }

// void doEqString(bool inv)
// {
//     Value* e2=doPop();
//     Value* e1=doPop();
//     bool eq = (e2->getString()->eq(e1->getString()));
//     if (inv) { eq = !eq; }
//     if (eq) {  push(new Value((void*)1,inttable)); }
//     else {  push(new Value((void*)0,inttable)); }
// }

// void int2str()
// {
//     // Need to do this on a copy or we break types.
//     Value* x = new Value(NULL,NULL);
//     x->setInt(doPop()->getInt());
//     x->int2str();
//     push(x);
// }

// void real2str()
// {
//     // Need to do this on a copy or we break types.
//     Value* x = new Value(NULL,NULL);
//     x->setReal(doPop()->getReal());
//     x->real2str();
//     push(x);
// }

// void str2int()
// {
//     // Need to do this on a copy or we break types.
//     Value* x = new Value(doPop()->getRaw(),inttable);
//     x->str2int();
//     push(x);
// }

// void str2real()
// {
//     // Need to do this on a copy or we break types.
//     Value* x = new Value(doPop()->getRaw(),realtable);
//     x->str2real();
//     push(x);
// }

// void chr2str()
// {
//     // Need to do this on a copy or we break types.
//     Value* x = new Value(doPop()->getRaw(),stringtable);
//     x->chr2str();
//     push(x);
// }

// void bool2str()
// {
//     // Need to do this on a copy or we break types.
//     Value* x = new Value(doPop()->getRaw(),stringtable);
//     x->bool2str();
//     push(x);
// }

// void str2chr()
// {
// //    valstack[stacksize-1]->str2chr();
//     assert(false);
// }

// void mkArray(int i)
// {
//     Array* array = new Array(i);
//     while(i>0) {
// 	Value* v= doPop();
// 	array->push_back(v);
// 	i--;
//     }

//     push(new Value(array,arraytable));
// }

// void projarg(int i, int t)
// {
//     Union* top = (Union*)doPop()->getRaw();

//     if (top->tag!=t) {
// 	kaya_throw("Wrong constructor used for projection",1);
//     }
//     Value* arg=top->args[i];
//     push(arg);
// }

// void goToIndex()
// {
//     --stacksize;
//     int idx = valstack[stacksize]->getInt();
//     valstack[stacksize-1] = valstack[stacksize-1]->lookup(idx);
// }

// /// Replace the top stack item with the contents of the second stack item.
// void setTop()
// {
//     valstack[stacksize-1]->setPtr(valstack[stacksize-2]);
//     valstack[stacksize-2]=valstack[stacksize-1];
//     stacksize-=2;
// }

// void pushglobal(char* modid, int i)
// {
//     Value** mglobs;
//     if (globs.find(modid)==globs.end()) {
// 	mglobs = (Value**)GC_MALLOC_UNCOLLECTABLE(sizeof(Value*)*globalloc);
// 	for(int i=0;i<globalloc;i++) { //TMP HACK
// 	    mglobs[i]=new Value(0,NULL);
// 	}
// 	globs[modid]=mglobs;

// //	cout << modid << "," << mglobs << endl;
//     }
//     else {
// 	mglobs = globs[modid];
// //	cout << modid << "," << mglobs << endl;
//     }
//     push(mglobs[i]);
// //    cout << i << " ," << mglobs[i] << endl;
// }

// void createglobal(char* modid, int i)
// {
//     cerr << "Do not run this function again" << endl;
//     exit(1);
//     Value** mglobs;
//     if (globs.find(modid)==globs.end()) {
// 	mglobs = (Value**)GC_MALLOC_UNCOLLECTABLE(sizeof(Value*)*globalloc);
// 	for(int i=0;i<globalloc;i++) { //TMP HACK
// 	    mglobs[i]=new Value(0,NULL);
// 	}
// 	globs[modid]=mglobs;
//     }
//     else {
// 	mglobs = globs[modid];
//     }
//     if (i>=globalloc)
//     {
// 	Value** newglobs = (Value**)GC_MALLOC_UNCOLLECTABLE(sizeof(Value*)*globalloc*2);
// 	for(int i=0;i<globalloc;i++)
// 	    newglobs[i]=mglobs[i];
// 	mglobs=newglobs;
// 	globalloc*=2;
// 	globs[modid]=mglobs;
//     }
// }

// void newjmp_buf()
// {
//     jmp_buf* b = new jmp_buf[1];
//     except_stack.push(b);
// //    stackdata *s = new stackdata();
// //    s->data = valstack;
// //    s->size = stacksize;
//     stack_stack.push(stacksize);

// //    cout << "Inside " << except_stack.size() << " tries" << endl;
// }

//id kaya_throw(char* msg,int code)
//
//  vm->kaya_throw(msg,code);
//
//     PUSH(MKSTR(msg));
//     PUSH(MKINT(code));
//     MKEXCEPT;
//     THROW;
// }

// void getindex()
// {
//     int idx = doPop()->getInt();
//     Value* array = doPop();
//     Value* el = array->lookup(idx);
//     push(el);
// }

Value* mkstr(char* str)
{
    return new Value((void*)(new String(str)),stringtable);
}

Value* mkint(void* i)
{
    return new Value(i,inttable);
}

Value* mkarrayval(void* i)
{
    return new Value(i,arraytable);
}

/// Maths operators

int intpower(int x, int y)
{
    return (int)pow((double)x,(double)y);
}

double realpower(double x, double y)
{
    return pow(x,y);
}
