#ifndef _VM_H // -*-C++-*-
#define _VM_H

/**
    Kaya run-time system
    Copyright (C) 2004, 2005 Edwin Brady

    This file is distributed under the terms of the GNU Lesser General
    Public Licence. See COPYING for licence.
*/

using namespace std;

#include <setjmp.h>

#include "Heap.h"
#include "Array.h"
#include "ValueFuns.h"
#include "Closure.h"
#include <iostream>
#include <stack>

/*struct stackdata: public gc {
    Value** data;
    int size;
    };*/

/*extern Value** valstack;
extern stack<jmp_buf*> except_stack;
extern stack<int> stack_stack;
extern int stacksize;
*/

class VMState;

//extern VMState* vm;

#define STARTFN int tmp;

#define DECLARE(x) Value *x = new Value(NULL,inttable);
// Args get initialised immediately anyway
#define DECLAREARG(x) Value *x
#define DECLAREQUICK(x) static Value *x = new Value(NULL,inttable);
#define TMPINT(x) int x
#define TMPREAL(x) double x
//#define ARRAY(x) x=new Value(ARRAY);
#define MKINT(x) mkint((void*)(x))
#define MKREAL(x) (new Value((void*)(new Real(x)),realtable))
#define MKCHAR(x) (new Value((void*)((int)x),inttable))
#define MKFUN(x) (new Value((void*)(new Closure(vm,x,0)),fntable))
#define MKSTR(x) mkstr(x)
#define MKUNION(x) (new Value((void*)x,uniontable))
#define MKCON(t,a) vm->push(new Value((void*)(new Union(vm,t,a)),uniontable))
#define MKEXCEPT vm->push(new Value((void*)(new Exception(vm)),exceptiontable))
//#define SET(x,i,y) x->setIdxPtr(y,i);
#define MKARRAYVAL(x) mkarrayval((void*)(x))

#define TOINDEX vm->goToIndex();
#define TOFIELD(i) vm->goToField(i);

#define MKARRAY(i) vm->mkArray(i)
#define CALL(x) (x(vm))
#define CALLFUN(x) (x->runClosure(vm))
#define TAILCALL(x) (x(vm))
#define TAILCALLFUN(x) (x->runClosure(vm))
#define CALLTOP (vm->doPop()->runClosure(vm))
#define TAILCALLTOP (vm->doPop()->runClosure(vm))

#define CLOSURE(x,i) vm->push(new Value((void*)(new Closure(vm,x,i)),fntable))

//#define GETFUN(x) (x->getFunc())
#define GETVAL(t) (t=vm->doPop()->getInt())
#define PUSHGETVAL(x,t) t=x->getInt()
#define GETRVAL(t) (t=vm->doPop()->getReal())
#define PUSHGETRVAL(x,t) t=x->getReal()
#define GETINDEX vm->getindex(); 
#define INTINFIX(t,op,x,y) t=(x op y)
#define REALINFIX(t,op,x,y) t=(x op y)
#define REALINFIXBOOL(op,x,y) vm->push(mkint((void*)(x op y)))
#define INTUNARY(t,op,x) t=(op x)
#define REALUNARY(t,op,x) t=(op x)
#define INTPOWER(t,x,y) t=intpower(x,y);
#define REALPOWER(t,x,y) t=realpower(x,y);
#define APPEND vm->doAppend();
#define EQEXCEPT vm->doEqExcept(false);
#define NEEXCEPT vm->doEqExcept(true);
#define EQSTRING vm->doEqString(false);
#define NESTRING vm->doEqString(true);
#define PRINTINT cout << vm->doPop()->getInt();
#define PRINTSTR cout << vm->doPop()->getString()->getVal();
#define PRINTEXC vm->doPop()->getExcept()->show();
#define INPUTINT vm->readInt();
#define INPUTSTR vm->readStr();
#define NEWLINE cout << endl
#define LABEL(x) x:
#define JUMP(x) goto x
#define JZ(x,y) if ((x->getInt())==0) goto y
#define JNZ(x,y) if ((x->getInt())!=0) goto y
#define JNEG(x,y) if ((x->getInt())<0) goto y
#define JPOS(x,y) if ((x->getInt())>0) goto y
#define JFALSE(x) if (vm->doPop()->getInt()==0) goto x
#define JTRUE(x) if (vm->doPop()->getInt()!=0) goto x
#define JTFALSE(t,x) if (t==0) goto x
#define JTTRUE(t,x) if (t!=0) goto x

#define PUSH(x) vm->push(x)
#define PUSH2(x,y) vm->push2(x,y)
#define PUSH3(x,y,z) vm->push3(x,y,z)
#define PUSH4(x,y,z,w) vm->push4(x,y,z,w)
#define PUSHSETTOP(x) vm->pushsettop(x);
#define DUMMY vm->push(new Value(0,inttable))
#define POP(x) x->setPtr(vm->doPop())
#define POPARG(x) x=vm->doPop()
#define DISCARD vm->doPop()

//#define SETVAL(x,y) x->setPtr(new Value((void*)y));
#define SETINT(x,y) x->setInt(y);
#define SETVAR(x,y) x->setPtr(y);
#define SETTOP vm->setTop();
#define ADDTOP vm->addTop();
#define SUBTOP vm->subTop();
#define MULTOP vm->mulTop();
#define DIVTOP vm->divTop();
#define PROJ(x,i) x->project(vm,i);
#define PROJARG(a,t) vm->projarg(a,t);
/* CIM 12/7/05: changed ERROR to KERROR for MinGW compatibility */
#define KERROR cerr << vm->doPop()->getString()->getVal(); exit(-1);

#define PUSHGLOBAL(t,i) vm->pushglobal(t,i)
#define CREATEGLOBAL(x,i) vm->newglobal(x,i)
#define TAG vm->tag()
#define VMPTR vm->push(new Value((void*)vm,inttable));

#define GETLENGTH vm->push(new Value((void*)(vm->doPop()->length()),inttable))
#define GETFNID vm->push(new Value((void*)(getFnID(vm->doPop()->getFunc())),inttable))

// Coercions
#define STR2INT vm->str2int();
#define INT2STR vm->int2str();
#define REAL2STR vm->real2str();
#define STR2REAL vm->str2real();
#define STR2CHR vm->str2chr();
#define CHR2STR vm->chr2str();
#define BOOL2STR vm->bool2str();
#define INT2REAL vm->int2real();
#define REAL2INT vm->real2int();
/* CIM 12/7/05: changed VOID to KVOID for MinGW compatibility */
#define KVOID(x) x

// Exceptions
#define TRY(x) \
    vm->newjmp_buf(); \
    if (setjmp(*(vm->top_ex()))==2) goto x; \

#define THROW vm->throw_ex();
#define TRIED vm->tried(); 
#define RESTORE vm->restore();

VMState* initstack();
void finish(VMState* vm);

//#define POPINDEX(x) x->setindex(doPop()->getInt(),doPop())

// Value* doPop();
// void push(Value* val);
// void mkArray(int size);
// /// Replace the top stack item with its ith argument.
// void projarg(int i, int t);
// void goToIndex();
// /// Replace the top stack item with the contents of the second stack item.
// void setTop();

// void pushglobal(char* modid, int i);
// void createglobal(char* modid,int i);

// int tag();

// void readInt();
// void readStr();
// void doAppend();
// void doEqExcept(bool inv);
// void doEqString(bool inv);

// void str2int();
// void int2str();
// void real2str();
// void str2real();
// void str2chr();
// void chr2str();
// void bool2str();

// void newjmp_buf();

// void addToFunMap(int id, func fn);
// func getFn(int id);
// int getFnID(func fn);

//void kaya_throw(char* msg, int code);
// void getindex();

Value* mkstr(char* str);
Value* mkint(void* i);
Value* mkarrayval(void* i);

/// Maths operators.
int intpower(int x, int y);
double realpower(double x, double y);

#endif
