#ifndef _VALUEFUNS_H
#define _VALUEFUNS_H

/**
    Kaya run-time system
    Copyright (C) 2004, 2005 Edwin Brady

    This file is distributed under the terms of the GNU Lesser General
    Public Licence. See COPYING for licence.
*/

#include <vector>

class Value;
class VMState;

/* CIM 12/7/05: changed INT to KINT for MinGW compatibility */
typedef enum { KINT, STRING, FUNC, ARRAY, UNION, EXCEPTION, REAL } valtype;

class FunTable : public gc {
public:
    virtual Value* eq(Value*, Value*) = 0;
    virtual Value* cmp(Value*, Value*) = 0;
    virtual Value* copy(Value*) = 0;
    virtual Value* marshal(VMState*, vector<Value*>&, Value*, int id) = 0;
    virtual Value* hash(Value*) = 0;
    virtual valtype getType() = 0;
};

class IntTable : public FunTable {
public:
    Value* eq(Value*, Value*);
    Value* cmp(Value*, Value*);
    Value* copy(Value*);
    Value* marshal(VMState*, vector<Value*>&, Value*, int id);
    Value* hash(Value*);
/* CIM 12/7/05: changed INT to KINT for MinGW compatibility */
    valtype getType() { return KINT; }
};

// (Actually, closures)
class FnTable : public FunTable {
public:
    Value* eq(Value*, Value*);
    Value* cmp(Value*, Value*);
    Value* copy(Value*);
    Value* marshal(VMState*, vector<Value*>&, Value*, int id);
    Value* hash(Value*);
    valtype getType() { return FUNC; }
};

class RealTable : public FunTable {
public:
    Value* eq(Value*, Value*);
    Value* cmp(Value*, Value*);
    Value* copy(Value*);
    Value* marshal(VMState*, vector<Value*>&, Value*, int id);
    Value* hash(Value*);
    valtype getType() { return REAL; }
};

class StringTable : public FunTable {
public:
    Value* eq(Value*, Value*);
    Value* cmp(Value*, Value*);
    Value* copy(Value*);
    Value* marshal(VMState*, vector<Value*>&, Value*, int id);
    Value* hash(Value*);
    valtype getType() { return STRING; }
};

class ArrayTable : public FunTable {
public:
    Value* eq(Value*, Value*);
    Value* cmp(Value*, Value*);
    Value* copy(Value*);
    Value* marshal(VMState*, vector<Value*>&, Value*, int id);
    Value* hash(Value*);
    valtype getType() { return ARRAY; }
};

class UnionTable : public FunTable {
public:
    Value* eq(Value*, Value*);
    Value* cmp(Value*, Value*);
    Value* copy(Value*);
    Value* marshal(VMState*, vector<Value*>&, Value*, int id);
    Value* hash(Value*);
    valtype getType() { return UNION; }

};

class ExceptionTable : public FunTable {
public:
    Value* eq(Value*, Value*);
    Value* cmp(Value*, Value*);
    Value* copy(Value*);
    Value* marshal(VMState*, vector<Value*>&, Value*, int id);
    Value* hash(Value*);
    valtype getType() { return EXCEPTION; }
};

extern FunTable* inttable;
extern FunTable* stringtable;
extern FunTable* fntable;
extern FunTable* arraytable;
extern FunTable* uniontable;
extern FunTable* exceptiontable;
extern FunTable* realtable;

#endif
