#ifndef _NETWORK_H // -*-C++-*-
#define _NETWORK_H

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>

#include <gc/gc.h>
#include <KayaAPI.h>

class ConnInfo : public gc {
public:
    int cid;
    struct sockaddr_in addr;
    socklen_t addrlen;
};

extern "C" {
/// Create a socket and connect to the server. Returns connection info.
    void* net_connect(void* vmptr,int proto,char* server, int port);
/// Create a socket and start listening. Returns socket id.
    int net_listen(void* vmptr,int proto, int port, int backlog);
/// Accept a connection. Returns connection info.
    void* net_accept(void* vmptr,int socket);
/// Shutdown a connection.
    void net_shutdown(void* conn);
/// Close a socket.
    void net_close(void* conn);
    void net_send(void* vmptr,void* conn, char* data);
    char* net_recv(void* vmptr,void* conn, KayaValue len);
/// Get the address of the host in the connection.
    char* net_getaddr(void* conn);
/// Return whether data is available on a socket
    bool net_pending(void* vm, void* conn, int timeout);
}

#endif
