{-
    Kaya - My favourite toy language.
    Copyright (C) 2004, 2005 Edwin Brady

    This file is distributed under the terms of the GNU General
    Public Licence. See COPYING for licence.
-}

module Driver(compileFile) where

import Parser
import Language
-- import Typecheck
import Inference
import TAC
import CodegenCPP
import Module
import APIDocs
import Options
import LambdaLift
import Optimise
import Propagate
import Inliner
import CallGraph
import PureFun
import Lib
import Errors

import System
import System.Directory
import Portability
import System.Random
import IO
import Debug.Trace
import List

-- Compile a file, with extra options to gcc, and main options
compileFile :: InputType -> Name -> FilePath -> [String] -> Options -> 
               IO ()
compileFile prtype modname fn extra opts =
    do libdirs <- getAllLibDirs opts
       pinput <- if (doprelude opts) 
		     then do
			    prelude <- 
				do foo <- Module.findFile libdirs "Prelude.ki" 
				   case foo of
				     Nothing -> return ""
				     (Just p) -> return p
			    return (parseprog "Prelude" libdirs prelude "Prelude.ki")
		     else return $ Success []
       prog <- readFile fn
       let (UN newroot) = modname
	  -- Parse properly, using the real module name, and startup code.
	  -- (This is a bit of a hack, but at least the last parse was mostly 
	  -- lazy)
       startup <- getStartup prtype libdirs
       let pt = addToPT (parse newroot libdirs (prog++startup) fn) pinput 
       compile newroot libdirs opts pt extra

outputfile Module mod = showuser mod ++ ".o"
-- TMP HACK: This should probably be a %extension "cgi" directive in the .ks
outputfile (Program "webapp") mod = showuser mod ++ ".cgi"
outputfile (Program "cgi") mod = showuser mod ++ ".cgi"
outputfile (Program _) mod = showuser mod
outputfile Shebang mod = showuser mod
-- outputfile Webapp mod = showuser mod ++ ".cgi"
-- outputfile Webprog mod = showuser mod ++ ".cgi"

compile :: String -> [FilePath] -> Options -> 
	   (Result ParseResult) -> [String] -> IO ()
compile root libdirs opts (Failure err file line) extra 
    = do putStrLn err
	 exitWith (ExitFailure 1)
compile root libdirs opts prog@(Success (PR t mod xs mdocstr)) extrain = 
    do dump (dumpraw opts) xs
       let extra = if t == Shebang then [] else extrain
       case (inferAll (UN root) empty [] [] empty [] empty [] (dumpeqns opts) xs opts) of
	    Success (ok,[],ctxt,_,_,_,_) -> 
                do let ok' = if (doprelude opts)
			       then (Imported "Prelude"):ok
			       else ok
                   comp' t root libdirs opts ctxt (nub (lambdalift ok')) extra mod mdocstr
	    Success (ok,errs,ctxt,_,_,_,_) -> 
                               do mapM_ reportError errs
				  exitWith (ExitFailure 1)
	    Failure err f l -> do reportError err
				  exitWith (ExitFailure 1)
  where	dump True raw = putStr $ concat (map ((\x -> x++"\n\n").show) raw)
	dump False raw = return ()

comp' t root libdirs opts ctxt ok extra mod mdocstr = do
       let globbed = findPure (sortprog (addGlobInit ok mod))

       let optLevel = if (noopts opts) then 0 else 1
       let inls = getInlinable globbed
       let optimised = runOpts optLevel globbed

       if (dumpcg opts) 
	  then putStrLn $ dumpCG (makeCG optimised)
	  else return ()
       dumppt (dumptree opts) optimised
       case (compileAll optimised mod) of
          Failure err f l -> do reportError err
				exitWith (ExitFailure 1)
	  Success comp -> do
	     let dynlinks = getdynlinks opts []
	     dlinks <- linkfiles libdirs dynlinks
	     (ofiles,linkopts) <- case t of 
		   Module -> return ([],[])
		   _ -> getObjs ok libdirs dlinks
	     let ifile = root ++ ".ki"
	     let xfile = root ++ ".xml"
	     let hfile = root ++ ".html"
	     doWriteIface t inls ifile optimised
	     doWriteXMLDocs (xmldocs opts) xfile optimised (root++".k") mdocstr
	     doWriteHTMLDocs (htmldocs opts) hfile optimised (root++".k")
--       putStrLn (show ok)
--       let name = tmpdir++root++".vcc"
--       putStrLn $ tmpdir++ " is tmp"
	     (tmpn,tmph) <- tempfile
--       putStrLn $ tmpn++ " is file"
	     aeskey <- case t of
                      Module -> return (RawCode $ "")
                      _ -> case getseed opts of
		                Nothing -> mkaeskey 0
		                (Just x) -> mkaeskey (hash x)
	     ivec <- case t of 
                     Module -> return (RawCode $ "")
                     _ -> case getseed opts of
		               Nothing -> mkivec 0
		               (Just x) -> mkivec (hash (x++"ivec"))
	     dump (dumptac opts) comp
    -- FIXME: (UN root) really ought to be mod, but I need to fix the
    -- parser to update the module name when it discovers what it is.
	     writeC (UN root) t libdirs ctxt 
			(addfnmap t optimised comp [aeskey,ivec]) tmph opts
	     let doprofile = if (profile opts) then "-g -pg " else ""
	     let dostatic = if (static opts) then case t of
                                                         Module -> ""
                                                         _ -> " -static -lpthread -lc " 
                                                         else ""
	     let cmd = "g++ " ++ nocheck ++ addc t ++ " " ++ 
		       " -O2 " ++ 
                       "-fno-optimize-sibling-calls " ++ 
		       --		 "-g " ++
		       doprofile ++
		       "-x c++ " ++
		       tmpn ++ " -x none -o " ++ 
		       outputfile t mod ++ " " ++ (unwords extra) ++ " " ++ 
		       incl libdirs ++ 
		       showlist ofiles ++ " " ++ showlist linkopts ++ " " ++
		       dolink t ++ dostatic
	     case showgcc opts of
		 True -> putStrLn cmd
		 False -> return ()
	     exit <- system cmd
	     copyc (keepc opts) tmpn root
	     removeFile tmpn
	     if (exit /= ExitSuccess) 
		then exitWith exit
		else return ()
  where addc Module = "-c"
	addc _ = ""
	dolink Module = ""
	dolink _ = libopts++" "++libvm++" -lgc"
        libopts = concat $ map (" -L"++) libpath
	libvm = if (nortchecks opts) then "-lkayavm-opt" else "-lkayavm"
	nocheck = if (nortchecks opts) then "-DNOCHECK " else ""
        doWriteIface Module inls ifile ok = writeIface inls ifile ok
	doWriteIface _ _ _ _ = return ()
	doWriteXMLDocs True dfile ok inf mdocstr = writeXMLDocs dfile ok inf mdocstr
	doWriteXMLDocs _ _ _ _ _ = return ()
	doWriteHTMLDocs True dfile ok inf = writeHTMLDocs dfile ok inf
	doWriteHTMLDocs _ _ _ _ = return ()
--	addfnmap Webapp ok comp dk = comp++((mkfnmap ok):dk)
--	addfnmap Webprog ok comp dk = comp++((mkfnmap ok):dk)
	addfnmap (Program _) ok comp dk = comp++((mkfnmap ok):(mkStartup ok):dk)
	addfnmap Shebang ok comp dk = comp++((mkfnmap ok):(mkStartup ok):dk)
	addfnmap Module ok comp dk = comp
	dump True tac = putStr $ showtac tac
	dump False tac = return ()
	dumppt True tree = putStr $ showtree tree
	dumppt False tree = return ()
	copyc True n cfn = do foo <- system $ "cp " ++ n ++ " " ++ cfn ++ ".cc"
			      return ()
	copyc False _ _ = return ()
	showlist [] = " "
	showlist (x:xs) = x ++ " " ++ showlist xs
	incl [] = ""
	incl (x:xs) = "-I"++(stripSlash x)++
                      " -L"++(stripSlash x)++" "++incl xs


showIfTrue :: Bool -> String -> IO ()
showIfTrue True str = putStrLn str
showIfTrue False _ = return ()

