// -*-C-*-ish

import Webapp;
import WebCommon;
import Crypto;
import HTMLDocument;

default Void webconfig() {}

Void __panic(String err, Int code)
{
  putStrLn("Status: 500 Internal Server Error");
  putStrLn("Content-type: text/plain; charset=UTF-8");
  putStrLn("Cache-control: no-cache,private");
  putStrLn("");
  putStrLn("Kaya panic: "+err+" ("+code+")");
}

Void __start() {
    Prelude::gcIncremental();
    //    void(Prelude::gcSetFSD(2));
    try {
      module::webconfig();
      
      WebCommon::initWebApp();
      
      displayPage(module::webmain());
    } catch(err) {
      if (!Webapp::headersSent) {
	putStrLn("Status: 500 Internal Server Error");
	putStrLn("Content-type: text/plain; charset=UTF-8");
	putStrLn("Cache-control: no-cache,private");
	putStrLn("");
      }
      putStrLn("An error has occurred.");
      if (Webapp::debugMode) {
	exceptionBacktrace(err);
      } else {
	putStrLn("Error details suppressed to protect security.");
      }
    }
    removeTemporaryUploaded();
}
