#include "glutglue.h"

#include <KayaAPI.h>
#include <GL/glut.h>

KayaValue displayfun, reshapefun, idlefun, keyfun, keyupfun,
      specialfun, specialupfun, mousefun, motionfun, visibilityfun;
KayaValue displaydata, reshapedata, idledata, keydata, keyupdata,
      specialdata, specialupdata, mousedata, motiondata, visibilitydata;

#define UTAG(x) switch(KayaUnionGetTag(x))

void do_glutCreateWindow(KString title)
{
    glutCreateWindow(CSTRING(title));
}

void display_cb(KayaValue fn, KayaValue data)
{
    displayfun = fn;
    displaydata = data;
    glutDisplayFunc(display);
}

void reshape_cb(KayaValue fn, KayaValue data)
{
    reshapefun = fn;
    reshapedata = data;
    glutReshapeFunc(reshape);
}

void idle_cb(KayaValue fn, KayaValue data)
{
    idlefun = fn;
    idledata = data;
    glutIdleFunc(idle);
}

void key_cb(KayaValue fn, KayaValue data)
{
    keyfun = fn;
    keydata = data;
    glutKeyboardFunc(keyboard);
}

void keyup_cb(KayaValue fn, KayaValue data)
{
    keyupfun = fn;
    keyupdata = data;
    glutKeyboardUpFunc(keyboardup);
}

void special_cb(KayaValue fn, KayaValue data)
{
    specialfun = fn;
    specialdata = data;
    glutSpecialFunc(special);
}

void specialup_cb(KayaValue fn, KayaValue data)
{
    specialfun = fn;
    specialdata = data;
    glutSpecialUpFunc(specialup);
}

void mouse_cb(KayaValue fn, KayaValue data)
{
    mousefun = fn;
    mousedata = data;
    glutMouseFunc(mouse);
}

void motion_cb(KayaValue fn, KayaValue data)
{
    motionfun = fn;
    motiondata = data;
    glutMotionFunc(motion);
}

void visibility_cb(KayaValue fn, KayaValue data)
{
    motionfun = fn;
    motiondata = data;
    glutVisibilityFunc(visibility);
}

void display()
{
    KayaCall(displayfun,1,displaydata);
}

void reshape(int x, int y)
{
    KayaCall(reshapefun,3,KayaInt(x),KayaInt(y),reshapedata);
}

void idle()
{
    KayaCall(idlefun,1,idledata);
}

void keyboard(unsigned char c, int x, int y)
{
    KayaCall(keyfun,4,KayaChar(c),KayaInt(x),KayaInt(y),keydata);
}

void keyboardup(unsigned char c, int x, int y)
{
    KayaCall(keyupfun,4,KayaChar(c),KayaInt(x),KayaInt(y),keyupdata);
}

void special(int key, int x, int y)
{
    KayaCall(specialfun,4,KayaInt(key),KayaInt(x),KayaInt(y),specialdata);
}

void specialup(int key, int x, int y)
{
    KayaCall(specialupfun,4,KayaInt(key),KayaInt(x),KayaInt(y),specialupdata);
}

void mouse(int buttonv, int statev, int x, int y)
{
    KayaValue button;
    KayaValue buttonstate;
    switch(buttonv) {
    case GLUT_LEFT_BUTTON: button = KayaUnion(0,0); break;
    case GLUT_MIDDLE_BUTTON: button = KayaUnion(1,0); break;
    case GLUT_RIGHT_BUTTON: button = KayaUnion(2,0); break;
    }
    switch(statev) {
    case GLUT_UP: buttonstate = KayaUnion(0,0); break;
    case GLUT_DOWN: buttonstate = KayaUnion(1,0); break;
    }
    KayaCall(mousefun,5,button,buttonstate,KayaInt(x),KayaInt(y), mousedata);
}

void motion(int x, int y)
{
    KayaCall(motionfun,3,KayaInt(x),KayaInt(y),motiondata);
}

void visibility(int state)
{
    KayaCall(visibilityfun,2,KayaInt(state),visibilitydata);
}

int _glut_getMode(KayaValue k)
{
    UTAG(k) {
    case 0: return GLUT_RGB;
    case 1: return GLUT_RGBA;
    case 2: return GLUT_INDEX;
    case 3: return GLUT_SINGLE;
    case 4: return GLUT_DOUBLE;
    case 5: return GLUT_ACCUM;
    case 6: return GLUT_ALPHA;
    case 7: return GLUT_DEPTH;
    case 8: return GLUT_STENCIL;
    case 9: return GLUT_MULTISAMPLE;
    case 10: return GLUT_STEREO;
    case 11: return GLUT_LUMINANCE;
    }
}

void doGlutInit(KayaArray modes)
{
    int fake_argc = 1;
    char *fake_argv[1];
    fake_argv[0]=(char*)"test";
    glutInit(&fake_argc, fake_argv) ;
    glutInitDisplayMode(orArray(modes,_glut_getMode));
}
