/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2004 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  $Id: kz-plugin.c,v 1.1 2004/10/20 11:34:17 makeinu Exp $
 */

#include "kz-plugin.h"
#include "gobject-utils.h"


static void kz_plugin_class_init   (KzPluginClass *klass);
static void kz_plugin_init         (KzPlugin      *plugin);
static void kz_plugin_dispose      (GObject       *object);

static GObjectClass *parent_class = NULL;


KZ_OBJECT_GET_TYPE(kz_plugin, "KzPlugin", KzPlugin,
		   kz_plugin_class_init, kz_plugin_init,
		   G_TYPE_OBJECT)
KZ_OBJECT_FINALIZE(kz_plugin, KzPlugin)


static void
kz_plugin_class_init (KzPluginClass *klass)
{
	GObjectClass *object_class;

	parent_class = g_type_class_peek_parent (klass);
	object_class = (GObjectClass *) klass;

	object_class->dispose  = kz_plugin_dispose;
	object_class->finalize = kz_plugin_finalize;
}


static void
kz_plugin_init (KzPlugin *plugin)
{
	plugin->module = NULL;
	plugin->priv   = NULL;
}

static void
kz_plugin_dispose (GObject *object)
{
	if (G_OBJECT_CLASS (parent_class)->dispose)
		G_OBJECT_CLASS (parent_class)->dispose(object);
}
