/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Takuro Ashie
 *  Copyright (C) 2005 Ryo SHIMIZU
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "prefs_bookmark.h"

#include <string.h>
#include <glib/gi18n.h>
#include "kazehakase.h"
#include "utils/gtk-utils.h"
#include "kz-tab-label.h"


#define DATA_KEY "KzPrefsBookmark::info"


static GtkWidget *prefs_bookmark_create          (void);
static void       prefs_bookmark_response        (GtkWidget *widget,
						  gint       response);


static KzPrefsWinPageEntry prefs_entry =
{
	path:            N_("/Bookmark"),
	priority_hint:   0,
	ui_level:        ~KZ_UI_LEVEL_BEGINNER,
	create:          prefs_bookmark_create,
	response:        prefs_bookmark_response,
};


typedef struct _KzPrefsBookmark
{
	GtkWidget     *main_vbox;
	GtkWidget     *bookmark_cutoff_strnum;
	GtkWidget     *keep_bookmark_menu;
	GtkWidget     *confirm_open_bookmarks;
	gboolean       changed;
} KzPrefsBookmark;


static void
cb_changed (GtkWidget *widget, KzPrefsBookmark *prefsui)
{
	prefsui->changed = TRUE;
}


static void
prefs_bookmark_destroy (gpointer data)
{
	KzPrefsBookmark *prefsui = data;

	g_free(prefsui);
}

static GtkWidget *
prefs_bookmark_create (void)
{
	KzPrefsBookmark *prefsui = g_new0(KzPrefsBookmark , 1);
	GtkWidget *main_vbox, *hbox, *vbox, *frame;
	GtkWidget *label, *check, *spin;
	GtkAdjustment *adj;
	gint bookmark_max_strnum;
	gboolean keep = FALSE, confirm = TRUE;

	main_vbox = gtk_vbox_new(FALSE, 0);
	prefsui->main_vbox = main_vbox;
	g_object_set_data_full(G_OBJECT(main_vbox), DATA_KEY,
			       prefsui, prefs_bookmark_destroy);

	label = kz_prefs_ui_utils_create_title(_("Bookmark"));
	gtk_box_pack_start(GTK_BOX(main_vbox), label,
			   FALSE, FALSE, 0);
	gtk_widget_show(label);

	/*
	 * view
	 */
	frame = gtk_frame_new(_("Appearance"));
	gtk_frame_set_label_align(GTK_FRAME(frame), 0.03, 0.5);
	gtk_container_set_border_width(GTK_CONTAINER(frame), 5);
	gtk_box_pack_start(GTK_BOX(main_vbox), frame, FALSE, FALSE, 2);
	gtk_widget_show(frame);

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(hbox), 4);
	gtk_container_add(GTK_CONTAINER(frame), hbox);
	gtk_widget_show(hbox);

	/* Bookmark title limitation */
	bookmark_max_strnum = 0;
	KZ_CONF_GET("Global" , "bookmark_cutoff_strnum" , bookmark_max_strnum , INT);

	label = gtk_label_new_with_mnemonic(_("The maximam number of characters of bookmark title "
				"If 0 is specified, show all"));
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 10);
	gtk_widget_show(label);

	prefsui->bookmark_cutoff_strnum = spin
		= gtk_spin_button_new_with_range(0, 100, 1);
	adj = gtk_spin_button_get_adjustment(GTK_SPIN_BUTTON(spin));
	gtk_adjustment_set_value(adj, bookmark_max_strnum);
	gtk_box_pack_start(GTK_BOX(hbox), spin, FALSE, FALSE, 2);
	g_signal_connect(spin, "value-changed",
			 G_CALLBACK(cb_changed), prefsui);
	gtk_widget_show(spin);

	/*
	 * behaviour 
	 */
	frame = gtk_frame_new(_("Behaviour"));
	gtk_frame_set_label_align(GTK_FRAME(frame), 0.03, 0.5);
	gtk_container_set_border_width(GTK_CONTAINER(frame), 5);
	gtk_box_pack_start(GTK_BOX(main_vbox), frame, FALSE, FALSE, 2);
	gtk_widget_show(frame);

	vbox = gtk_vbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(vbox), 4);
	gtk_container_add(GTK_CONTAINER(frame), vbox);
	gtk_widget_show(vbox);

	check = gtk_check_button_new_with_mnemonic(_("Keep menu _open by middle click"));
	prefsui->keep_bookmark_menu = check;
	gtk_box_pack_start(GTK_BOX(vbox), check, FALSE, FALSE, 2);
	KZ_CONF_GET("Global", "keep_bookmark_menu", keep, BOOL);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check), keep);
	g_signal_connect(check, "toggled",
			 G_CALLBACK(cb_changed), prefsui);
	gtk_widget_show(check);

	check = gtk_check_button_new_with_mnemonic(_("_Confirmation of opening all bookmarks in bookmark folder"));
	prefsui->confirm_open_bookmarks = check;
	gtk_box_pack_start(GTK_BOX(vbox), check, FALSE, FALSE, 2);
	KZ_CONF_GET("Global", "confirm_open_bookmarks", confirm, BOOL);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check), confirm);
	g_signal_connect(check, "toggled",
			 G_CALLBACK(cb_changed), prefsui);
	gtk_widget_show(check);

	prefsui->changed = FALSE;

	return main_vbox;
}


static void
prefs_bookmark_response (GtkWidget *widget, gint response)
{
	KzPrefsBookmark *prefsui = g_object_get_data(G_OBJECT(widget), DATA_KEY);

	g_return_if_fail(prefsui);

	switch (response) {
	case GTK_RESPONSE_ACCEPT:
	case GTK_RESPONSE_APPLY:
	{
		GtkAdjustment *adj;
		gint bookmark_max_strnum;
		gboolean keep;
		
		if (!prefsui->changed)
			break;

		adj = gtk_spin_button_get_adjustment
			(GTK_SPIN_BUTTON(prefsui->bookmark_cutoff_strnum));
		bookmark_max_strnum = gtk_adjustment_get_value(adj);
		KZ_CONF_SET("Global", "bookmark_cutoff_strnum", bookmark_max_strnum, INT);

		keep = gtk_toggle_button_get_active
			(GTK_TOGGLE_BUTTON(prefsui->keep_bookmark_menu));
		KZ_CONF_SET("Global", "keep_bookmark_menu", keep, BOOL);

		keep = gtk_toggle_button_get_active
			(GTK_TOGGLE_BUTTON(prefsui->confirm_open_bookmarks));
		KZ_CONF_SET("Global", "confirm_open_bookmarks", keep, BOOL);

		prefsui->changed = FALSE;

		break;
	}
	case GTK_RESPONSE_REJECT:
		break;
	case KZ_RESPONSE_UI_LEVEL_MEDIUM:
		break;
	case KZ_RESPONSE_UI_LEVEL_EXPERT:
		break;
	case KZ_RESPONSE_UI_LEVEL_CUSTOM:
		break;
	default:
		break;
	}
}


KzPrefsWinPageEntry *
prefs_bookmark_get_entry (gint idx)
{
	if (idx == 0)
		return &prefs_entry;
	else
		return NULL;
}
