/* -*- c-file-style: "ruby"; indent-tabs-mode: nil -*- */

/*
 *  Copyright (C) 2006 Kouhei Sutou <kou@cozmixng.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "kz-rb-ext.h"

#include "kz-sidebar.h"

#define _SELF(obj) (KZ_SIDEBAR(RVAL2GOBJ(obj)))
#define RVAL2GTKWIDGET(obj) (GTK_WIDGET(RVAL2GOBJ(obj)))

static VALUE mKzSidebarFactory;

static VALUE
rb_kz_sidebar_new(VALUE self, VALUE kz)
{
    GtkWidget *sidebar;

    sidebar = kz_sidebar_new(RVAL2KZWIN(kz));
    RBGTK_INITIALIZE(self, sidebar);

    return Qnil;
}

static VALUE
rb_kz_sidebar_get_current(VALUE self)
{
    return CSTR2RVAL(kz_sidebar_get_current(_SELF(self)));
}

static VALUE
rb_kz_sidebar_set_current(VALUE self, VALUE label)
{
    return RVAL2CBOOL(kz_sidebar_set_current(_SELF(self), RVAL2CSTR(label)));
}

static GtkWidget *
rb_kz_sidebar_entry_create (KzSidebarEntry *entry, KzSidebar *sidebar)
{
    VALUE widget;

    widget = rb_funcall(mKzSidebarFactory, rb_intern("create"),
                        2, CSTR2RVAL(entry->label), GOBJ2RVAL(sidebar));

    return NIL_P(widget) ? NULL : RVAL2GTKWIDGET(widget);
}

void
kz_rb_setup_sidebar(KzWindow *kz)
{
    int i, len;
    VALUE entries;

    entries = rb_funcall(mKzSidebarFactory, rb_intern("entries"), 0);

    len = RARRAY(entries)->len;
    for (i = 0; i < len; i++) {
        VALUE entry_info;
        KzSidebarEntry *entry;

        entry_info = RARRAY(entries)->ptr[i];
        entry = g_new0(KzSidebarEntry, 1);
        entry->priority_hint = NUM2INT(RARRAY(entry_info)->ptr[0]);
        entry->label = RVAL2CSTR(RARRAY(entry_info)->ptr[1]);
        entry->icon = RVAL2CSTR2(RARRAY(entry_info)->ptr[2]);
        entry->create = rb_kz_sidebar_entry_create;
        kz_sidebar_append_entry(entry);
    }
}

void
Init_kz_rb_sidebar(VALUE mKz)
{
    VALUE cKzSidebar;

    cKzSidebar = G_DEF_CLASS(KZ_TYPE_SIDEBAR, "Sidebar", mKz);
    mKzSidebarFactory = rb_define_module_under(mKz, "SidebarFactory");

    rb_define_method(cKzSidebar, "initialize", rb_kz_sidebar_new, 1);

    rb_define_method(cKzSidebar, "current", rb_kz_sidebar_get_current, 0);
    rb_define_method(cKzSidebar, "set_current", rb_kz_sidebar_set_current, 1);

    G_DEF_SETTERS(cKzSidebar);
}
