/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

#ifndef __KZ_NAVI_H__
#define __KZ_NAVI_H__

#include <glib.h>
#include <glib-object.h>

G_BEGIN_DECLS

#define KZ_TYPE_NAVI		(kz_navi_get_type ())
#define KZ_NAVI(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_NAVI, KzNavi))
#define KZ_NAVI_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), KZ_TYPE_NAVI, KzNaviClass))
#define KZ_IS_NAVI(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_NAVI))
#define KZ_IS_NAVI_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), KZ_TYPE_NAVI))
#define KZ_NAVI_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), KZ_TYPE_NAVI, KzFeedInfoClass))

typedef struct _KzNavi      KzNavi;
typedef struct _KzNaviClass KzNaviClass;

struct _KzNavi
{
	GObject parent;

	gchar    *name;
	gchar    *uri;
	gchar    *title;
	gchar    *type;
};

struct _KzNaviClass
{
	GObjectClass parent_class;
};

GType   kz_navi_get_type      (void) G_GNUC_CONST;
KzNavi *kz_navi_new           (void);
KzNavi *kz_navi_new_with_info (const gchar *name,
			       const gchar *uri,
                               const gchar *title,
			       const gchar *type);
void    kz_navi_add_bookmark  (KzNavi *navi);

G_END_DECLS

#endif /* __KZ_NAVI_H__ */
