/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2006 Ryo SHIMIZU
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __RASTSEARCH_H__
#define __RASTSEARCH_H__

#include <glib.h>
#include <kz-bookmark.h>

G_BEGIN_DECLS

gchar      *rast_get_search_result (const gchar* text);

KzBookmark *rast_get_search_result_bookmark (const gchar* text);

gboolean    rast_update_index      (gpointer data);
gboolean    rast_purge_index       (void);
GPid        rast_optimize_index    (void);
void        rast_make_index              (void);
gboolean    rast_exist_index_dir         (void);

G_END_DECLS

#endif /* __RASTSEARCH_H__ */
