// -*- Mode: C++; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*-

//
//  Copyright (C) 2002-2003 Hiroyuki Ikezoe
//  Copyright (C) 2003 Takuro Ashie
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#ifdef HAVE_CONFIG_H
#	include "config.h"
#endif

#define MOZILLA_CLIENT

#include <gtkmozembed.h>
#include <nsCOMPtr.h>
#include <nsXPCOM.h>
#include <nsIGenericFactory.h>
#include <nsIComponentRegistrar.h>
#define MOZILLA_INTERNAL_API
#include <nsIServiceManager.h>
#undef MOZILLA_INTERNAL_API
#include <nsBuildID.h>
#include <sys/utsname.h>

#include "mozilla.h"
#include "mozilla-prefs.h"
#include "kz-mozfilepicker.h"
#include "kz-mozlauncher.h"
#include "kz-mozprogresslistener.h"
#include "kz-mozprintingpromptservice.h"
#include "kazehakase.h"
#include "kz-mozhistorysearch.h"
#include "kz-mozselectionlistener.h"
#ifdef HAVE_NSIBADCERTLISTNER_H
#  include "GtkNSSDialogs.h"
#endif
#include "GtkPromptService.h"


NS_GENERIC_FACTORY_CONSTRUCTOR(KzFilePicker)
NS_GENERIC_FACTORY_CONSTRUCTOR(KzContentHandler)
NS_GENERIC_FACTORY_CONSTRUCTOR(KzMozProgressListener)
NS_GENERIC_FACTORY_CONSTRUCTOR(KzMozHistorySearchProtocolHandler)
NS_GENERIC_FACTORY_CONSTRUCTOR(KzMozPrintingPromptService)
NS_GENERIC_FACTORY_CONSTRUCTOR(GtkPromptService)
#ifdef HAVE_NSIBADCERTLISTNER_H
NS_GENERIC_FACTORY_CONSTRUCTOR(GtkNSSDialogs)
#endif

static const nsModuleComponentInfo sAppComps[] = {
	{
		KZ_DOWNLOAD_CLASSNAME,
		KZ_DOWNLOAD_CID,
#ifdef HAVE_NSITRANSFER_H
		NS_TRANSFER_CONTRACTID,
#else
		NS_DOWNLOAD_CONTRACTID,
#endif
		KzMozProgressListenerConstructor
	},
	{
		KZ_FILEPICKER_CLASSNAME,
		KZ_FILEPICKER_CID,
		KZ_FILEPICKER_CONTRACTID,
		KzFilePickerConstructor
	},
	{
		NS_IHELPERAPPLAUNCHERDLG_CLASSNAME,
		KZ_CONTENTHANDLER_CID,
		NS_IHELPERAPPLAUNCHERDLG_CONTRACTID,
		KzContentHandlerConstructor
	},
	{
		KZ_HISTORY_SEARCH_PROTOCOLHANDLER_CLASSNAME,
		KZ_HISTORY_SEARCH_PROTOCOLHANDLER_CID,
		KZ_HISTORY_SEARCH_PROTOCOLHANDLER_CONTRACTID,
		KzMozHistorySearchProtocolHandlerConstructor
	},
	{
		KZ_PRINTINGPROMPTSERVICE_CLASSNAME,
		KZ_PRINTINGPROMPTSERVICE_CID,
		KZ_PRINTINGPROMPTSERVICE_CONTRACTID,
		KzMozPrintingPromptServiceConstructor
	},
#ifdef HAVE_NSIBADCERTLISTNER_H
	{
		GTK_NSSDIALOGS_CLASSNAME,
		GTK_NSSDIALOGS_CID,
		NS_BADCERTLISTENER_CONTRACTID,
		GtkNSSDialogsConstructor
	},
	{
		GTK_NSSDIALOGS_CLASSNAME,
		GTK_NSSDIALOGS_CID,
		NS_CERTIFICATEDIALOGS_CONTRACTID,
		GtkNSSDialogsConstructor
	},
#endif
  	{
		"Prompt Service",
    		NS_PROMPTSERVICE_CID,
    		"@mozilla.org/embedcomp/prompt-service;1",
    		GtkPromptServiceConstructor
	},
};
static const int sNumAppComps = G_N_ELEMENTS(sAppComps);

#ifndef HAVE_NSIDOCSHELL_GETSECUREUI
/* bee4dc31-1326-4c08-9bda-7b230dca97e9 */
#define NEW_CID { 0xbee4dc31, 0x1326, 0x4c08, { 0x9b, 0xda, 0x7b, 0x23, 0x0d, 0xca, 0x97, 0xe9 } }

static nsresult
reregister_secure_browser_ui (nsIComponentManager *cm, nsIComponentRegistrar *cr)
{
	nsresult rv;
	
	/* Workaround as a result of:
	 *  https://bugzilla.mozilla.org/show_bug.cgi?id=94974
	 * see
	 *  http://bugzilla.gnome.org/show_bug.cgi?id=164670
	 */
	nsCOMPtr<nsIFactory> factory;
	rv = cm->GetClassObjectByContractID ("@mozilla.org/secure_browser_ui;1", 
					     NS_GET_IID(nsIFactory), getter_AddRefs (factory));
	NS_ENSURE_SUCCESS (rv, rv);

	nsCID *cidPtr = nsnull;
	rv = cr->ContractIDToCID("@mozilla.org/secure_browser_ui;1", &cidPtr);
	NS_ENSURE_SUCCESS (rv, rv);

	rv = cr->UnregisterFactory (*cidPtr, factory);
	NS_ENSURE_SUCCESS (rv, rv);

	const nsCID new_cid = NEW_CID;
	rv = cr->RegisterFactory (new_cid, "Kazehakase Secure Browser Class",
				  "@kazehakase.sf.jp/hacks/secure-browser-ui;1", factory);
	NS_ENSURE_SUCCESS (rv, rv);

	return NS_OK;
}
#endif

gboolean
mozilla_register_components (void)
{
	gboolean ret = TRUE;
	nsresult rv;

	nsCOMPtr<nsIComponentRegistrar> cr;
	rv = NS_GetComponentRegistrar(getter_AddRefs(cr));
	NS_ENSURE_SUCCESS(rv, rv);

	nsCOMPtr<nsIComponentManager> cm;
	NS_GetComponentManager (getter_AddRefs (cm));
	NS_ENSURE_TRUE (cm, FALSE);

	for (int i = 0; i < sNumAppComps; i++)
	{
		nsCOMPtr<nsIGenericFactory> componentFactory;
		rv = NS_NewGenericFactory(getter_AddRefs(componentFactory),
					  &(sAppComps[i]));
		if (NS_FAILED(rv))
		{
			ret = FALSE;
			continue;  // don't abort registering other components
		}

		rv = cr->RegisterFactory(sAppComps[i].mCID,
					 sAppComps[i].mDescription,
					 sAppComps[i].mContractID,
					 componentFactory);
		if (NS_FAILED(rv))
			ret = FALSE;
	}

#ifndef HAVE_NSIDOCSHELL_GETSECUREUI
        // Workaround for http://bugzilla.gnome.org/show_bug.cgi?id=164670
        reregister_secure_browser_ui (cm, cr);
#endif
	return ret;
}

