/***************************************************************************
                          labelprinter.h  -  description
                             -------------------
    begin                : Son Mai 5 2002
    copyright            : (C) 2002 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LABELPRINTER_H
#define LABELPRINTER_H

#include "dsmainwindow.h"
#include "labelutils.h"
#include "xmlutils.h"
#include "definition.h"
#include "batchiface.h"

class BatchPrinter;
class Label;
class KIntNumInput;
class KListView;
class KPrinter;
class KComboBox;
class KCompletion;
class KLineEdit;
class KPopupMenu;
class KURLRequester;
class QBuffer;
class QFile;
class QListViewItem;
class QGroupBox;
class QLabel;
class QPixmap;
class KPushButton;
class QHBoxLayout;
class QVBoxLayout;
class Measurements;
/** The powerful batch printing module of KBarcode.
  */
class LabelPrinter : public DSMainWindow, public BatchIface, private LabelUtils, private XMLUtils
{
    Q_OBJECT
    public:
        LabelPrinter( QString filename, QWidget* parent=0, const char *name= 0,
            WFlags f = WType_TopLevel );
        ~LabelPrinter();

        void setCustomerId( const QString & id );
        void setLabelURL( const QString & url );

    public slots:
        void print( bool immediately = false, const QString & printer = QString::null );

    private:
        bool existsArticle( const QString & article );
        void loadData( QFile* file = 0, const QString & data = QString::null );
        void setupActions();
        void fillWithData( BatchPrinter* batch );
        /** never forget to delete buffer! */
        QBuffer* getBuffer();
        /** add an item to the group completion object */
        void addGroupCompletion( const QString & group );

    private slots:
        void setupSql();
        void addItem();
        bool addItem( const QString & article, const QString & group, int count, bool msgbox = true );
        void addAllItems();
        void editItem();
        /** return a list of all articles in barcode basic */
        const QStringList allItems();
        void changeDescription();

        void loadFromFile();
        void loadFromFile( const QString & url );
        void loadFromClipboard();

        void removeItem();
        void updateInfo();

        void customerNameChanged( int index );
        void customerIdChanged( int index );

        void changeItem( QListViewItem* item, const QPoint &, int col );
        void enableControls();

        void images();

    protected:
        Definition* def;
        int labels; // labels to print

        KListView* list;
        KURLRequester* urlrequester;
        KPushButton* buttonPrint;
        KPushButton* buttonImages;
        KPushButton* buttonAdd;
        KPushButton* buttonAddAll;
        KPushButton* buttonEdit;
        KPushButton* buttonRemove;
        KPushButton* buttonRemoveAll;

        KComboBox* customerName;
        KComboBox* customerId;
        KCompletion* compGroup;
        KLineEdit* serialStart;
        KIntNumInput* serialInc;
        KPopupMenu* mnuImport;

        QString description;
        QLabel* info1;
        QLabel* info2;
        QLabel* info3;
        QLabel* info4;
        QLabel* info5;
        
        QVBoxLayout* pageLayout;
        QHBoxLayout* buttonLayout;
};

#endif
